/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.ObjectMarker;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.bluemap.common.api.marker.MarkerImpl;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;

public abstract class ObjectMarkerImpl
extends MarkerImpl
implements ObjectMarker {
    private String detail = null;
    private boolean hasUnsavedChanges = true;

    public ObjectMarkerImpl(String id, BlueMapMap map, Vector3d position) {
        super(id, map, position);
    }

    @Override
    public String getDetail() {
        if (this.detail == null) {
            return this.getLabel();
        }
        return this.detail;
    }

    @Override
    public void setDetail(String detail) {
        this.detail = detail;
        this.hasUnsavedChanges = true;
    }

    @Override
    public void load(BlueMapAPI api, ConfigurationNode markerNode, boolean overwriteChanges) throws MarkerFileFormatException {
        super.load(api, markerNode, overwriteChanges);
        if (!overwriteChanges && this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        this.detail = markerNode.node("detail").getString();
    }

    @Override
    public void save(ConfigurationNode markerNode) throws SerializationException {
        super.save(markerNode);
        if (this.detail != null) {
            markerNode.node("detail").set(this.detail);
        }
        this.hasUnsavedChanges = false;
    }
}

