/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.Line;
import de.bluecolored.bluemap.api.marker.Marker;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.api.marker.Shape;
import de.bluecolored.bluemap.common.api.marker.ExtrudeMarkerImpl;
import de.bluecolored.bluemap.common.api.marker.HtmlMarkerImpl;
import de.bluecolored.bluemap.common.api.marker.LineMarkerImpl;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.bluemap.common.api.marker.MarkerImpl;
import de.bluecolored.bluemap.common.api.marker.POIMarkerImpl;
import de.bluecolored.bluemap.common.api.marker.ShapeMarkerImpl;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MarkerSetImpl
implements MarkerSet {
    private final String id;
    private String label;
    private boolean toggleable;
    private boolean isDefaultHidden;
    private final Map<String, MarkerImpl> markers;
    private final Set<String> removedMarkers;
    private boolean hasUnsavedChanges;

    public MarkerSetImpl(String id) {
        this.id = id;
        this.label = id;
        this.toggleable = true;
        this.isDefaultHidden = false;
        this.markers = new ConcurrentHashMap<String, MarkerImpl>();
        this.removedMarkers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.hasUnsavedChanges = true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public synchronized void setLabel(String label) {
        this.label = label;
        this.hasUnsavedChanges = true;
    }

    @Override
    public boolean isToggleable() {
        return this.toggleable;
    }

    @Override
    public synchronized void setToggleable(boolean toggleable) {
        this.toggleable = toggleable;
        this.hasUnsavedChanges = true;
    }

    @Override
    public boolean isDefaultHidden() {
        return this.isDefaultHidden;
    }

    @Override
    public synchronized void setDefaultHidden(boolean defaultHide) {
        this.isDefaultHidden = defaultHide;
        this.hasUnsavedChanges = true;
    }

    @Override
    public Collection<Marker> getMarkers() {
        return Collections.unmodifiableCollection(this.markers.values());
    }

    @Override
    public Optional<Marker> getMarker(String id) {
        return Optional.ofNullable((Marker)this.markers.get(id));
    }

    @Override
    public synchronized POIMarkerImpl createPOIMarker(String id, BlueMapMap map, Vector3d position) {
        this.removeMarker(id);
        POIMarkerImpl marker = new POIMarkerImpl(id, map, position);
        this.markers.put(id, marker);
        return marker;
    }

    @Override
    public HtmlMarkerImpl createHtmlMarker(String id, BlueMapMap map, Vector3d position, String html) {
        this.removeMarker(id);
        HtmlMarkerImpl marker = new HtmlMarkerImpl(id, map, position, html);
        this.markers.put(id, marker);
        return marker;
    }

    @Override
    public synchronized ShapeMarkerImpl createShapeMarker(String id, BlueMapMap map, Vector3d position, Shape shape, float y) {
        this.removeMarker(id);
        ShapeMarkerImpl marker = new ShapeMarkerImpl(id, map, position, shape, y);
        this.markers.put(id, marker);
        return marker;
    }

    @Override
    public ExtrudeMarkerImpl createExtrudeMarker(String id, BlueMapMap map, Vector3d position, Shape shape, float minY, float maxY) {
        this.removeMarker(id);
        ExtrudeMarkerImpl marker = new ExtrudeMarkerImpl(id, map, position, shape, minY, maxY);
        this.markers.put(id, marker);
        return marker;
    }

    @Override
    public LineMarkerImpl createLineMarker(String id, BlueMapMap map, Vector3d position, Line line) {
        this.removeMarker(id);
        LineMarkerImpl marker = new LineMarkerImpl(id, map, position, line);
        this.markers.put(id, marker);
        return marker;
    }

    @Override
    public synchronized boolean removeMarker(String id) {
        if (this.markers.remove(id) != null) {
            this.removedMarkers.add(id);
            return true;
        }
        return false;
    }

    public synchronized void load(BlueMapAPI api, ConfigurationNode node, boolean overwriteChanges) throws MarkerFileFormatException {
        BlueMapMap dummyMap = api.getMaps().iterator().next();
        Shape dummyShape = Shape.createRect(0.0, 0.0, 1.0, 1.0);
        Line dummyLine = new Line(Vector3d.ZERO, Vector3d.ONE);
        HashSet<String> externallyRemovedMarkers = new HashSet<String>(this.markers.keySet());
        block16: for (ConfigurationNode configurationNode : node.node("marker").childrenList()) {
            String id = configurationNode.node("id").getString();
            String type = configurationNode.node("type").getString();
            if (id == null || type == null) {
                Logger.global.logDebug("Marker-API: Failed to load a marker in the set '" + this.id + "': No id or type defined!");
                continue;
            }
            externallyRemovedMarkers.remove(id);
            if (!overwriteChanges && this.removedMarkers.contains(id)) continue;
            MarkerImpl marker = this.markers.get(id);
            try {
                if (marker == null || !marker.getType().equals(type)) {
                    switch (type) {
                        case "html": {
                            marker = new HtmlMarkerImpl(id, dummyMap, Vector3d.ZERO, "");
                            break;
                        }
                        case "poi": {
                            marker = new POIMarkerImpl(id, dummyMap, Vector3d.ZERO);
                            break;
                        }
                        case "shape": {
                            marker = new ShapeMarkerImpl(id, dummyMap, Vector3d.ZERO, dummyShape, 0.0f);
                            break;
                        }
                        case "extrude": {
                            marker = new ExtrudeMarkerImpl(id, dummyMap, Vector3d.ZERO, dummyShape, 0.0f, 1.0f);
                            break;
                        }
                        case "line": {
                            marker = new LineMarkerImpl(id, dummyMap, Vector3d.ZERO, dummyLine);
                            break;
                        }
                        default: {
                            Logger.global.logDebug("Marker-API: Failed to load marker '" + id + "' in the set '" + this.id + "': Unknown marker-type '" + type + "'!");
                            continue block16;
                        }
                    }
                    marker.load(api, configurationNode, true);
                } else {
                    marker.load(api, configurationNode, overwriteChanges);
                }
                if (overwriteChanges) {
                    this.markers.put(id, marker);
                    continue;
                }
                this.markers.putIfAbsent(id, marker);
            }
            catch (MarkerFileFormatException ex) {
                Logger.global.logDebug("Marker-API: Failed to load marker '" + id + "' in the set '" + this.id + "': " + ex);
            }
        }
        if (overwriteChanges) {
            for (String string : externallyRemovedMarkers) {
                this.markers.remove(string);
            }
            this.removedMarkers.clear();
        }
        if (!overwriteChanges && this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        this.label = node.node("label").getString(this.id);
        this.toggleable = node.node("toggleable").getBoolean(true);
        this.isDefaultHidden = node.node("defaultHide").getBoolean(false);
    }

    public synchronized void save(ConfigurationNode node) throws SerializationException {
        node.node("id").set(this.id);
        node.node("label").set(this.label);
        node.node("toggleable").set(this.toggleable);
        node.node("defaultHide").set(this.isDefaultHidden);
        for (MarkerImpl marker : this.markers.values()) {
            marker.save(node.node("marker").appendListNode());
        }
        this.removedMarkers.clear();
        this.hasUnsavedChanges = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerSetImpl markerSet = (MarkerSetImpl)o;
        return this.id.equals(markerSet.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

