/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.Marker;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.util.Objects;
import java.util.Optional;

public abstract class MarkerImpl
implements Marker {
    private final String id;
    private BlueMapMap map;
    private Vector3d postition;
    private double minDistance;
    private double maxDistance;
    private String label;
    private String link;
    private boolean newTab;
    private boolean hasUnsavedChanges;

    public MarkerImpl(String id, BlueMapMap map, Vector3d position) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(map);
        Objects.requireNonNull(position);
        this.id = id;
        this.map = map;
        this.postition = position;
        this.minDistance = 0.0;
        this.maxDistance = 100000.0;
        this.label = id;
        this.link = null;
        this.newTab = true;
        this.hasUnsavedChanges = true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public abstract String getType();

    @Override
    public BlueMapMap getMap() {
        return this.map;
    }

    @Override
    public synchronized void setMap(BlueMapMap map) {
        this.map = map;
        this.hasUnsavedChanges = true;
    }

    @Override
    public Vector3d getPosition() {
        return this.postition;
    }

    @Override
    public synchronized void setPosition(Vector3d position) {
        this.postition = position;
        this.hasUnsavedChanges = true;
    }

    @Override
    public double getMinDistance() {
        return this.minDistance;
    }

    @Override
    public synchronized void setMinDistance(double minDistance) {
        this.minDistance = minDistance;
        this.hasUnsavedChanges = true;
    }

    @Override
    public double getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public synchronized void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
        this.hasUnsavedChanges = true;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public synchronized void setLabel(String label) {
        this.label = label;
        this.hasUnsavedChanges = true;
    }

    @Override
    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    @Override
    public boolean isNewTab() {
        return this.newTab;
    }

    @Override
    public synchronized void setLink(String link, boolean newTab) {
        this.link = link;
        this.newTab = newTab;
        this.hasUnsavedChanges = true;
    }

    @Override
    public synchronized void removeLink() {
        this.link = null;
        this.hasUnsavedChanges = true;
    }

    public synchronized void load(BlueMapAPI api, ConfigurationNode markerNode, boolean overwriteChanges) throws MarkerFileFormatException {
        if (!overwriteChanges && this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        String mapId = markerNode.node("map").getString();
        if (mapId == null) {
            throw new MarkerFileFormatException("There is no map defined!");
        }
        this.map = api.getMap(mapId).orElseThrow(() -> new MarkerFileFormatException("Could not resolve map with id: " + mapId));
        this.postition = MarkerImpl.readPos(markerNode.node("position"));
        this.minDistance = markerNode.node("minDistance").getDouble(0.0);
        this.maxDistance = markerNode.node("maxDistance").getDouble(100000.0);
        this.label = markerNode.node("label").getString(this.id);
        this.link = markerNode.node("link").getString();
        this.newTab = markerNode.node("newTab").getBoolean(true);
    }

    public synchronized void save(ConfigurationNode markerNode) throws SerializationException {
        markerNode.node("id").set(this.id);
        markerNode.node("type").set(this.getType());
        markerNode.node("map").set(this.map.getId());
        MarkerImpl.writePos(markerNode.node("position"), this.postition);
        markerNode.node("minDistance").set((double)Math.round(this.minDistance * 1000.0) / 1000.0);
        markerNode.node("maxDistance").set((double)Math.round(this.maxDistance * 1000.0) / 1000.0);
        markerNode.node("label").set(this.label);
        markerNode.node("link").set(this.link);
        markerNode.node("newTab").set(this.newTab);
        this.hasUnsavedChanges = false;
    }

    private static Vector3d readPos(ConfigurationNode node) throws MarkerFileFormatException {
        ConfigurationNode nx = node.node("x");
        ConfigurationNode ny = node.node("y");
        ConfigurationNode nz = node.node("z");
        if (nx.virtual() || ny.virtual() || nz.virtual()) {
            throw new MarkerFileFormatException("Failed to read position: One of the nodes x,y or z is missing!");
        }
        return new Vector3d(nx.getDouble(), ny.getDouble(), nz.getDouble());
    }

    private static void writePos(ConfigurationNode node, Vector3d pos) throws SerializationException {
        node.node("x").set((double)Math.round(pos.getX() * 1000.0) / 1000.0);
        node.node("y").set((double)Math.round(pos.getY() * 1000.0) / 1000.0);
        node.node("z").set((double)Math.round(pos.getZ() * 1000.0) / 1000.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerImpl marker = (MarkerImpl)o;
        return this.id.equals(marker.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

