/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.bluemap.common.api.marker.MarkerSetImpl;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.FileUtils;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MarkerAPIImpl
implements MarkerAPI {
    private BlueMapAPIImpl api;
    private File markerFile;
    private Map<String, MarkerSetImpl> markerSets;
    private Set<String> removedMarkerSets;

    public MarkerAPIImpl(BlueMapAPIImpl api, File markerFile) throws IOException {
        this.api = api;
        this.markerFile = markerFile;
        this.markerSets = new ConcurrentHashMap<String, MarkerSetImpl>();
        this.removedMarkerSets = Collections.newSetFromMap(new ConcurrentHashMap());
        this.load();
    }

    @Override
    public Collection<MarkerSet> getMarkerSets() {
        return Collections.unmodifiableCollection(this.markerSets.values());
    }

    @Override
    public Optional<MarkerSet> getMarkerSet(String id) {
        return Optional.ofNullable((MarkerSet)this.markerSets.get(id));
    }

    @Override
    public synchronized MarkerSet createMarkerSet(String id) {
        MarkerSetImpl set = this.markerSets.get(id);
        if (set == null) {
            set = new MarkerSetImpl(id);
            this.markerSets.put(id, set);
        }
        return set;
    }

    @Override
    public synchronized boolean removeMarkerSet(String id) {
        if (this.markerSets.remove(id) != null) {
            this.removedMarkerSets.add(id);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void load() throws IOException {
        this.load(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load(boolean overwriteChanges) throws IOException {
        Class<MarkerAPIImpl> clazz = MarkerAPIImpl.class;
        synchronized (MarkerAPIImpl.class) {
            HashSet<String> externallyRemovedSets = new HashSet<String>(this.markerSets.keySet());
            if (this.markerFile.exists() && this.markerFile.isFile()) {
                GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().file(this.markerFile)).build();
                Object node = loader.load();
                for (ConfigurationNode configurationNode : node.node("markerSets").childrenList()) {
                    String setId = configurationNode.node("id").getString();
                    if (setId == null) {
                        Logger.global.logDebug("Marker-API: Failed to load a markerset: No id defined!");
                        continue;
                    }
                    externallyRemovedSets.remove(setId);
                    if (!overwriteChanges && this.removedMarkerSets.contains(setId)) continue;
                    MarkerSetImpl set = this.markerSets.get(setId);
                    try {
                        if (set == null) {
                            set = new MarkerSetImpl(setId);
                            set.load(this.api, configurationNode, true);
                        } else {
                            set.load(this.api, configurationNode, overwriteChanges);
                        }
                        this.markerSets.put(setId, set);
                    }
                    catch (MarkerFileFormatException ex) {
                        Logger.global.logDebug("Marker-API: Failed to load marker-set '" + setId + ": " + ex);
                    }
                }
            }
            if (overwriteChanges) {
                for (String setId : externallyRemovedSets) {
                    this.markerSets.remove(setId);
                }
                this.removedMarkerSets.clear();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void save() throws IOException {
        Class<MarkerAPIImpl> clazz = MarkerAPIImpl.class;
        synchronized (MarkerAPIImpl.class) {
            this.load(false);
            FileUtils.createFile(this.markerFile);
            GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().file(this.markerFile)).build();
            Object node = loader.createNode();
            for (MarkerSetImpl set : this.markerSets.values()) {
                set.save(node.node("markerSets").appendListNode());
            }
            loader.save((ConfigurationNode)node);
            this.removedMarkerSets.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

