/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.Line;
import de.bluecolored.bluemap.api.marker.LineMarker;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.bluemap.common.api.marker.ObjectMarkerImpl;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.awt.Color;
import java.util.List;
import java.util.Objects;

public class LineMarkerImpl
extends ObjectMarkerImpl
implements LineMarker {
    public static final String MARKER_TYPE = "line";
    private Line line;
    private boolean depthTest;
    private int lineWidth;
    private Color lineColor;
    private boolean hasUnsavedChanges;

    public LineMarkerImpl(String id, BlueMapMap map, Vector3d position, Line line) {
        super(id, map, position);
        Objects.requireNonNull(line);
        this.line = line;
        this.lineWidth = 2;
        this.lineColor = new Color(255, 0, 0, 200);
        this.hasUnsavedChanges = true;
    }

    @Override
    public String getType() {
        return MARKER_TYPE;
    }

    @Override
    public Line getLine() {
        return this.line;
    }

    @Override
    public synchronized void setLine(Line line) {
        Objects.requireNonNull(line);
        this.line = line;
        this.hasUnsavedChanges = true;
    }

    @Override
    public boolean isDepthTestEnabled() {
        return this.depthTest;
    }

    @Override
    public void setDepthTestEnabled(boolean enabled) {
        this.depthTest = enabled;
        this.hasUnsavedChanges = true;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.hasUnsavedChanges = true;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public synchronized void setLineColor(Color color) {
        Objects.requireNonNull(color);
        this.lineColor = color;
        this.hasUnsavedChanges = true;
    }

    @Override
    public void load(BlueMapAPI api, ConfigurationNode markerNode, boolean overwriteChanges) throws MarkerFileFormatException {
        super.load(api, markerNode, overwriteChanges);
        if (!overwriteChanges && this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        this.line = this.readLine(markerNode.node(MARKER_TYPE));
        this.depthTest = markerNode.node("depthTest").getBoolean(true);
        this.lineWidth = markerNode.node("lineWidth").getInt(2);
        this.lineColor = LineMarkerImpl.readColor(markerNode.node("lineColor"));
    }

    @Override
    public void save(ConfigurationNode markerNode) throws SerializationException {
        super.save(markerNode);
        LineMarkerImpl.writeLine(markerNode.node(MARKER_TYPE), this.line);
        markerNode.node("depthTest").set(this.depthTest);
        markerNode.node("lineWidth").set(this.lineWidth);
        LineMarkerImpl.writeColor(markerNode.node("lineColor"), this.lineColor);
        this.hasUnsavedChanges = false;
    }

    private Line readLine(ConfigurationNode node) throws MarkerFileFormatException {
        List<? extends ConfigurationNode> posNodes = node.childrenList();
        if (posNodes.size() < 3) {
            throw new MarkerFileFormatException("Failed to read line: point-list has fewer than 2 entries!");
        }
        Vector3d[] positions = new Vector3d[posNodes.size()];
        for (int i = 0; i < positions.length; ++i) {
            positions[i] = LineMarkerImpl.readLinePos(posNodes.get(i));
        }
        return new Line(positions);
    }

    private static Vector3d readLinePos(ConfigurationNode node) throws MarkerFileFormatException {
        ConfigurationNode nx = node.node("x");
        ConfigurationNode ny = node.node("y");
        ConfigurationNode nz = node.node("z");
        if (nx.virtual() || ny.virtual() || nz.virtual()) {
            throw new MarkerFileFormatException("Failed to read line position: Node x, y or z is not set!");
        }
        return new Vector3d(nx.getDouble(), ny.getDouble(), nz.getDouble());
    }

    private static Color readColor(ConfigurationNode node) throws MarkerFileFormatException {
        ConfigurationNode nr = node.node("r");
        ConfigurationNode ng = node.node("g");
        ConfigurationNode nb = node.node("b");
        ConfigurationNode na = node.node("a");
        if (nr.virtual() || ng.virtual() || nb.virtual()) {
            throw new MarkerFileFormatException("Failed to read color: Node r,g or b is not set!");
        }
        float alpha = (float)na.getDouble(1.0);
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new MarkerFileFormatException("Failed to read color: alpha value out of range (0-1)!");
        }
        try {
            return new Color(nr.getInt(), ng.getInt(), nb.getInt(), (int)(alpha * 255.0f));
        }
        catch (IllegalArgumentException ex) {
            throw new MarkerFileFormatException("Failed to read color: " + ex.getMessage(), ex);
        }
    }

    private static void writeLine(ConfigurationNode node, Line line) throws SerializationException {
        for (int i = 0; i < line.getPointCount(); ++i) {
            ConfigurationNode pointNode = node.appendListNode();
            Vector3d point = line.getPoint(i);
            pointNode.node("x").set((double)Math.round(point.getX() * 1000.0) / 1000.0);
            pointNode.node("y").set((double)Math.round(point.getY() * 1000.0) / 1000.0);
            pointNode.node("z").set((double)Math.round(point.getZ() * 1000.0) / 1000.0);
        }
    }

    private static void writeColor(ConfigurationNode node, Color color) throws SerializationException {
        int r = color.getRed();
        int g2 = color.getGreen();
        int b = color.getBlue();
        float a = (float)color.getAlpha() / 255.0f;
        node.node("r").set(r);
        node.node("g").set(g2);
        node.node("b").set(b);
        node.node("a").set(Float.valueOf(a));
    }
}

