/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.HtmlMarker;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.bluemap.common.api.marker.MarkerImpl;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;

public class HtmlMarkerImpl
extends MarkerImpl
implements HtmlMarker {
    public static final String MARKER_TYPE = "html";
    private String html;
    private Vector2i anchor;
    private boolean hasUnsavedChanges;

    public HtmlMarkerImpl(String id, BlueMapMap map, Vector3d position, String html) {
        super(id, map, position);
        this.html = html;
        this.anchor = new Vector2i(25, 45);
        this.hasUnsavedChanges = true;
    }

    @Override
    public String getType() {
        return MARKER_TYPE;
    }

    @Override
    public Vector2i getAnchor() {
        return this.anchor;
    }

    @Override
    public void setAnchor(Vector2i anchor) {
        this.anchor = anchor;
        this.hasUnsavedChanges = true;
    }

    @Override
    public String getHtml() {
        return this.html;
    }

    @Override
    public synchronized void setHtml(String html) {
        this.html = html;
        this.hasUnsavedChanges = true;
    }

    @Override
    public synchronized void load(BlueMapAPI api, ConfigurationNode markerNode, boolean overwriteChanges) throws MarkerFileFormatException {
        super.load(api, markerNode, overwriteChanges);
        if (!overwriteChanges && this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        this.html = markerNode.node(MARKER_TYPE).getString("");
        this.anchor = HtmlMarkerImpl.readAnchor(markerNode.node("anchor"));
    }

    @Override
    public synchronized void save(ConfigurationNode markerNode) throws SerializationException {
        super.save(markerNode);
        markerNode.node(MARKER_TYPE).set(this.html);
        HtmlMarkerImpl.writeAnchor(markerNode.node("anchor"), this.anchor);
        this.hasUnsavedChanges = false;
    }

    private static Vector2i readAnchor(ConfigurationNode node) {
        return new Vector2i(node.node("x").getInt(0), node.node("y").getInt(0));
    }

    private static void writeAnchor(ConfigurationNode node, Vector2i anchor) throws SerializationException {
        node.node("x").set(anchor.getX());
        node.node("y").set(anchor.getY());
    }
}

