/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.core.world.World;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;

public class BlueMapWorldImpl
implements BlueMapWorld {
    private BlueMapAPIImpl api;
    private World delegate;
    private Collection<BlueMapMap> maps;

    protected BlueMapWorldImpl(BlueMapAPIImpl api, World delegate) {
        this.api = api;
        this.delegate = delegate;
    }

    @Override
    public Path getSaveFolder() {
        return this.delegate.getSaveFolder();
    }

    @Override
    public UUID getUuid() {
        return this.delegate.getUUID();
    }

    @Override
    public Collection<BlueMapMap> getMaps() {
        if (this.maps == null) {
            this.maps = Collections.unmodifiableCollection(this.api.getMaps().stream().filter(map -> map.getWorld().equals(this)).collect(Collectors.toList()));
        }
        return this.maps;
    }

    public World getWorld() {
        return this.delegate;
    }
}

