/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.common.api.BlueMapWorldImpl;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import java.util.function.Predicate;

public class BlueMapMapImpl
implements BlueMapMap {
    private BlueMapAPIImpl api;
    private BmMap delegate;

    protected BlueMapMapImpl(BlueMapAPIImpl api, BmMap delegate) {
        this.api = api;
        this.delegate = delegate;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public BlueMapWorldImpl getWorld() {
        return this.api.getWorldForUuid(this.delegate.getWorld().getUUID());
    }

    @Override
    public Vector2i getTileSize() {
        return this.delegate.getHiresModelManager().getTileGrid().getGridSize();
    }

    @Override
    public Vector2i getTileOffset() {
        return this.delegate.getHiresModelManager().getTileGrid().getOffset();
    }

    @Override
    public void setTileFilter(Predicate<Vector2i> filter) {
        this.delegate.setTileFilter(filter);
    }

    @Override
    public Predicate<Vector2i> getTileFilter() {
        return this.delegate.getTileFilter();
    }

    @Override
    public boolean isFrozen() {
        return !this.api.plugin.getPluginState().getMapState(this.delegate).isUpdateEnabled();
    }

    @Override
    public synchronized void setFrozen(boolean frozen) {
        if (this.isFrozen()) {
            this.unfreeze();
        } else {
            this.freeze();
        }
    }

    private synchronized void unfreeze() {
        this.api.plugin.startWatchingMap(this.delegate);
        this.api.plugin.getPluginState().getMapState(this.delegate).setUpdateEnabled(true);
        this.api.plugin.getRenderManager().scheduleRenderTask(new MapUpdateTask(this.delegate));
    }

    private synchronized void freeze() {
        this.api.plugin.stopWatchingMap(this.delegate);
        this.api.plugin.getPluginState().getMapState(this.delegate).setUpdateEnabled(false);
        this.api.plugin.getRenderManager().removeRenderTasksIf(task -> {
            if (task instanceof MapUpdateTask) {
                return ((MapUpdateTask)task).getMap().equals(this.delegate);
            }
            if (task instanceof WorldRegionRenderTask) {
                return ((WorldRegionRenderTask)task).getMap().equals(this.delegate);
            }
            return false;
        });
    }

    public BmMap getMapType() {
        return this.delegate;
    }
}

