/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.common.api.BlueMapMapImpl;
import de.bluecolored.bluemap.common.api.BlueMapWorldImpl;
import de.bluecolored.bluemap.common.api.marker.MarkerAPIImpl;
import de.bluecolored.bluemap.common.api.render.RenderAPIImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.util.FileUtils;
import de.bluecolored.bluemap.core.world.World;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.imageio.ImageIO;

public class BlueMapAPIImpl
extends BlueMapAPI {
    private static final String IMAGE_ROOT_PATH = "images";
    public Plugin plugin;
    public RenderAPIImpl renderer;
    public Map<UUID, BlueMapWorldImpl> worlds;
    public Map<String, BlueMapMapImpl> maps;

    public BlueMapAPIImpl(Plugin plugin) {
        this.plugin = plugin;
        this.renderer = new RenderAPIImpl(this, plugin);
        this.worlds = new HashMap<UUID, BlueMapWorldImpl>();
        for (World world : plugin.getWorlds()) {
            BlueMapWorldImpl w = new BlueMapWorldImpl(this, world);
            this.worlds.put(w.getUuid(), w);
        }
        this.maps = new HashMap<String, BlueMapMapImpl>();
        for (BmMap map : plugin.getMapTypes()) {
            BlueMapMapImpl m3 = new BlueMapMapImpl(this, map);
            this.maps.put(m3.getId(), m3);
        }
    }

    @Override
    public RenderAPIImpl getRenderAPI() {
        return this.renderer;
    }

    @Override
    public MarkerAPIImpl getMarkerAPI() throws IOException {
        return new MarkerAPIImpl(this, new File(this.plugin.getRenderConfig().getWebRoot(), "data" + File.separator + "markers.json"));
    }

    @Override
    public Collection<BlueMapMap> getMaps() {
        return Collections.unmodifiableCollection(this.maps.values());
    }

    @Override
    public Collection<BlueMapWorld> getWorlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    @Override
    public String createImage(BufferedImage image, String path) throws IOException {
        path = path.replaceAll("[^a-zA-Z0-9_.\\-/]", "_");
        Path webRoot = this.plugin.getRenderConfig().getWebRoot().toPath().toAbsolutePath();
        String separator = webRoot.getFileSystem().getSeparator();
        Path webDataRoot = webRoot.resolve("data");
        Path imagePath = webDataRoot.resolve(Paths.get(IMAGE_ROOT_PATH, path.replace("/", separator) + ".png")).toAbsolutePath();
        File imageFile = imagePath.toFile();
        if (imageFile.exists()) {
            org.apache.commons.io.FileUtils.forceDelete((File)imageFile);
        }
        FileUtils.createFile(imageFile);
        if (!ImageIO.write((RenderedImage)image, "png", imagePath.toFile())) {
            throw new IOException("The format 'png' is not supported!");
        }
        return webRoot.relativize(imagePath).toString().replace(separator, "/");
    }

    @Override
    public Map<String, String> availableImages() throws IOException {
        Path webRoot = this.plugin.getRenderConfig().getWebRoot().toPath().toAbsolutePath();
        String separator = webRoot.getFileSystem().getSeparator();
        Path imageRootPath = webRoot.resolve("data").resolve(IMAGE_ROOT_PATH).toAbsolutePath();
        HashMap<String, String> availableImagesMap = new HashMap<String, String>();
        try (Stream<Path> fileStream = Files.walk(imageRootPath, new FileVisitOption[0]);){
            fileStream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".png")).map(Path::toAbsolutePath).forEach(p -> {
                try {
                    String key = imageRootPath.relativize((Path)p).toString();
                    key = key.substring(0, key.length() - 4).replace(separator, "/");
                    String value = webRoot.relativize((Path)p).toString().replace(separator, "/");
                    availableImagesMap.put(key, value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
        }
        return availableImagesMap;
    }

    @Override
    public Path getWebRoot() {
        return this.plugin.getRenderConfig().getWebRoot().toPath();
    }

    @Override
    public String getBlueMapVersion() {
        return BlueMap.VERSION;
    }

    @Override
    public Optional<BlueMapWorld> getWorld(UUID uuid) {
        return Optional.ofNullable((BlueMapWorld)this.worlds.get(uuid));
    }

    @Override
    public Optional<BlueMapMap> getMap(String id) {
        return Optional.ofNullable((BlueMapMap)this.maps.get(id));
    }

    public BlueMapWorldImpl getWorldForUuid(UUID uuid) {
        BlueMapWorldImpl world = this.worlds.get(uuid);
        if (world == null) {
            throw new IllegalArgumentException("There is no world loaded with this UUID: " + uuid.toString());
        }
        return world;
    }

    public BlueMapMapImpl getMapForId(String mapId) {
        BlueMapMapImpl map = this.maps.get(mapId);
        if (map == null) {
            throw new IllegalArgumentException("There is no map loaded with this id: " + mapId);
        }
        return map;
    }

    public void register() {
        try {
            BlueMapAPI.registerInstance(this);
        }
        catch (ExecutionException ex) {
            Logger.global.logError("BlueMapAPI: A BlueMapAPIListener threw an exception (onEnable)!", ex.getCause());
        }
    }

    public void unregister() {
        try {
            BlueMapAPI.unregisterInstance(this);
        }
        catch (ExecutionException ex) {
            Logger.global.logError("BlueMapAPI: A BlueMapAPIListener threw an exception (onDisable)!", ex.getCause());
        }
    }
}

