/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common;

import de.bluecolored.bluemap.core.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class WebFilesManager {
    private final File webRoot;

    public WebFilesManager(File webRoot) {
        this.webRoot = webRoot;
    }

    public boolean needsUpdate() {
        return !new File(this.webRoot, "index.html").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles() throws IOException {
        URL fileResource = this.getClass().getResource("/de/bluecolored/bluemap/webapp.zip");
        File tempFile = File.createTempFile("bluemap_webroot_extraction", null);
        try {
            FileUtils.copyURLToFile((URL)fileResource, (File)tempFile, (int)10000, (int)10000);
            try (ZipFile zipFile = new ZipFile(tempFile);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) {
                        File dir = new File(this.webRoot, zipEntry.getName());
                        FileUtils.forceMkdir((File)dir);
                        continue;
                    }
                    File target = new File(this.webRoot, zipEntry.getName());
                    FileUtils.forceMkdirParent((File)target);
                    FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(zipEntry), (File)target);
                }
            }
        }
        finally {
            if (!tempFile.delete()) {
                Logger.global.logWarning("Failed to delete file: " + tempFile);
            }
        }
    }
}

