/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common;

import de.bluecolored.bluemap.common.MissingResourcesException;
import de.bluecolored.bluemap.common.ThrowingFunction;
import de.bluecolored.bluemap.common.WebFilesManager;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.plugin.serverinterface.ServerInterface;
import de.bluecolored.bluemap.common.web.WebSettings;
import de.bluecolored.bluemap.core.MinecraftVersion;
import de.bluecolored.bluemap.core.config.ConfigManager;
import de.bluecolored.bluemap.core.config.CoreConfig;
import de.bluecolored.bluemap.core.config.MapConfig;
import de.bluecolored.bluemap.core.config.RenderConfig;
import de.bluecolored.bluemap.core.config.WebServerConfig;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.World;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

@DebugDump
public class BlueMapService {
    private final MinecraftVersion minecraftVersion;
    private final File configFolder;
    private final ThrowingFunction<File, UUID, IOException> worldUUIDProvider;
    private final ThrowingFunction<UUID, String, IOException> worldNameProvider;
    private final ConfigManager configManager;
    private CoreConfig coreConfig;
    private RenderConfig renderConfig;
    private WebServerConfig webServerConfig;
    private ResourcePack resourcePack;
    private Map<UUID, World> worlds;
    private Map<String, BmMap> maps;

    public BlueMapService(MinecraftVersion minecraftVersion, File configFolder) {
        this.minecraftVersion = minecraftVersion;
        this.configFolder = configFolder;
        HashMap uuids = new HashMap();
        this.worldUUIDProvider = file -> {
            UUID uuid = (UUID)uuids.get(file);
            if (uuid == null) {
                uuid = UUID.randomUUID();
                uuids.put(file, uuid);
            }
            return uuid;
        };
        this.worldNameProvider = uuid -> null;
        this.configManager = new ConfigManager();
    }

    public BlueMapService(MinecraftVersion minecraftVersion, ServerInterface serverInterface) {
        this.minecraftVersion = minecraftVersion;
        this.configFolder = serverInterface.getConfigFolder();
        this.worldUUIDProvider = serverInterface::getUUIDForWorld;
        this.worldNameProvider = serverInterface::getWorldName;
        this.configManager = new ConfigManager();
    }

    public synchronized void createOrUpdateWebApp(boolean force) throws IOException {
        WebFilesManager webFilesManager = new WebFilesManager(this.getRenderConfig().getWebRoot());
        if (force || webFilesManager.needsUpdate()) {
            webFilesManager.updateFiles();
        }
    }

    public synchronized WebSettings updateWebAppSettings() throws IOException, InterruptedException {
        WebSettings webSettings = new WebSettings(new File(this.getRenderConfig().getWebRoot(), "data" + File.separator + "settings.json"));
        webSettings.set(this.getRenderConfig().isUseCookies(), "useCookies");
        webSettings.set(this.getRenderConfig().isEnableFreeFlight(), "freeFlightEnabled");
        webSettings.setAllMapsEnabled(false);
        for (BmMap map : this.getMaps().values()) {
            webSettings.setMapEnabled(true, map.getId());
            webSettings.setFrom(map);
        }
        int ordinal = 0;
        for (MapConfig map : this.getRenderConfig().getMapConfigs()) {
            if (!this.getMaps().containsKey(map.getId())) continue;
            webSettings.setOrdinal(ordinal++, map.getId());
            webSettings.setFrom(map);
        }
        webSettings.save();
        return webSettings;
    }

    public synchronized Map<UUID, World> getWorlds() throws IOException, InterruptedException {
        if (this.worlds == null) {
            this.loadWorldsAndMaps();
        }
        return this.worlds;
    }

    public synchronized Map<String, BmMap> getMaps() throws IOException, InterruptedException {
        if (this.maps == null) {
            this.loadWorldsAndMaps();
        }
        return this.maps;
    }

    private synchronized void loadWorldsAndMaps() throws IOException, InterruptedException {
        this.maps = new HashMap<String, BmMap>();
        this.worlds = new HashMap<UUID, World>();
        for (MapConfig mapConfig : this.getRenderConfig().getMapConfigs()) {
            UUID worldUUID;
            String id = mapConfig.getId();
            String name = mapConfig.getName();
            File worldFolder = new File(mapConfig.getWorldPath());
            if (!worldFolder.exists() || !worldFolder.isDirectory()) {
                Logger.global.logWarning("Failed to load map '" + id + "': '" + worldFolder.getCanonicalPath() + "' does not exist or is no directory!");
                continue;
            }
            try {
                worldUUID = this.worldUUIDProvider.apply(worldFolder);
            }
            catch (IOException e) {
                Logger.global.logError("Failed to load map '" + id + "': Failed to get UUID for the world!", e);
                continue;
            }
            World world = this.worlds.get(worldUUID);
            if (world == null) {
                try {
                    world = MCAWorld.load(worldFolder.toPath(), worldUUID, this.worldNameProvider.apply(worldUUID), mapConfig.getWorldSkyLight(), mapConfig.isIgnoreMissingLightData());
                    this.worlds.put(worldUUID, world);
                }
                catch (MissingResourcesException e) {
                    throw e;
                }
                catch (IOException e) {
                    Logger.global.logError("Failed to load map '" + id + "'!", e);
                    continue;
                }
            }
            BmMap map = new BmMap(id, name, world, this.getRenderConfig().getWebRoot().toPath().resolve("data").resolve(id), this.getResourcePack(), mapConfig);
            this.maps.put(id, map);
        }
        this.worlds = Collections.unmodifiableMap(this.worlds);
        this.maps = Collections.unmodifiableMap(this.maps);
    }

    public synchronized ResourcePack getResourcePack() throws IOException, InterruptedException {
        if (this.resourcePack == null) {
            File defaultResourceFile = new File(this.getCoreConfig().getDataFolder(), "minecraft-client-" + this.minecraftVersion.getResource().getVersion().getVersionString() + ".jar");
            File resourceExtensionsFile = new File(this.getCoreConfig().getDataFolder(), "resourceExtensions.zip");
            File textureExportFile = new File(this.getRenderConfig().getWebRoot(), "data" + File.separator + "textures.json");
            File resourcePackFolder = new File(this.configFolder, "resourcepacks");
            FileUtils.forceMkdir((File)resourcePackFolder);
            if (!defaultResourceFile.exists()) {
                if (this.getCoreConfig().isDownloadAccepted()) {
                    try {
                        Logger.global.logInfo("Downloading " + this.minecraftVersion.getResource().getClientUrl() + " to " + defaultResourceFile + " ...");
                        FileUtils.forceMkdirParent((File)defaultResourceFile);
                        FileUtils.copyURLToFile((URL)new URL(this.minecraftVersion.getResource().getClientUrl()), (File)defaultResourceFile, (int)10000, (int)10000);
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to download resources!", e);
                    }
                } else {
                    throw new MissingResourcesException();
                }
            }
            Logger.global.logInfo("Loading resources...");
            if (resourceExtensionsFile.exists()) {
                FileUtils.forceDelete((File)resourceExtensionsFile);
            }
            FileUtils.forceMkdirParent((File)resourceExtensionsFile);
            URL resourceExtensionsUrl = Objects.requireNonNull(Plugin.class.getResource("/de/bluecolored/bluemap/" + this.minecraftVersion.getResource().getResourcePrefix() + "/resourceExtensions.zip"));
            FileUtils.copyURLToFile((URL)resourceExtensionsUrl, (File)resourceExtensionsFile, (int)10000, (int)10000);
            Object[] resourcePacks = resourcePackFolder.listFiles();
            if (resourcePacks == null) {
                resourcePacks = new File[]{};
            }
            Arrays.sort(resourcePacks);
            ArrayList<File> resources = new ArrayList<File>(resourcePacks.length + 1);
            resources.add(defaultResourceFile);
            resources.addAll(Arrays.asList(resourcePacks));
            resources.add(resourceExtensionsFile);
            try {
                this.resourcePack = new ResourcePack();
                if (textureExportFile.exists()) {
                    this.resourcePack.loadTextureFile(textureExportFile);
                }
                this.resourcePack.load(resources);
                this.resourcePack.saveTextureFile(textureExportFile);
            }
            catch (ParseResourceException e) {
                throw new IOException("Failed to parse resources!", e);
            }
        }
        return this.resourcePack;
    }

    public synchronized ConfigManager getConfigManager() {
        return this.configManager;
    }

    public File getCoreConfigFile() {
        return new File(this.configFolder, "core.conf");
    }

    public synchronized CoreConfig getCoreConfig() throws IOException {
        if (this.coreConfig == null) {
            this.coreConfig = new CoreConfig(this.configManager.loadOrCreate(this.getCoreConfigFile(), Plugin.class.getResource("/de/bluecolored/bluemap/core.conf"), Plugin.class.getResource("/de/bluecolored/bluemap/core-defaults.conf"), true, true));
        }
        return this.coreConfig;
    }

    public File getRenderConfigFile() {
        return new File(this.configFolder, "render.conf");
    }

    public synchronized RenderConfig getRenderConfig() throws IOException {
        if (this.renderConfig == null) {
            this.renderConfig = new RenderConfig(this.configManager.loadOrCreate(this.getRenderConfigFile(), Plugin.class.getResource("/de/bluecolored/bluemap/render.conf"), Plugin.class.getResource("/de/bluecolored/bluemap/render-defaults.conf"), true, true));
        }
        return this.renderConfig;
    }

    public File getWebServerConfigFile() {
        return new File(this.configFolder, "webserver.conf");
    }

    public synchronized WebServerConfig getWebServerConfig() throws IOException {
        if (this.webServerConfig == null) {
            this.webServerConfig = new WebServerConfig(this.configManager.loadOrCreate(this.getWebServerConfigFile(), Plugin.class.getResource("/de/bluecolored/bluemap/webserver.conf"), Plugin.class.getResource("/de/bluecolored/bluemap/webserver-defaults.conf"), true, true));
        }
        return this.webServerConfig;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }
}

