/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.marker;

import com.flowpowered.math.vector.Vector2d;
import java.util.Arrays;

public class Shape {
    private final Vector2d[] points;
    private Vector2d min = null;
    private Vector2d max = null;

    public Shape(Vector2d ... points) {
        if (points.length < 3) {
            throw new IllegalArgumentException("A shape has to have at least 3 points!");
        }
        this.points = points;
    }

    public int getPointCount() {
        return this.points.length;
    }

    public Vector2d getPoint(int i) {
        return this.points[i];
    }

    public Vector2d[] getPoints() {
        return Arrays.copyOf(this.points, this.points.length);
    }

    public Vector2d getMin() {
        if (this.min == null) {
            Vector2d min2 = this.points[0];
            for (int i = 1; i < this.points.length; ++i) {
                min2 = min2.min(this.points[i]);
            }
            this.min = min2;
        }
        return this.min;
    }

    public Vector2d getMax() {
        if (this.max == null) {
            Vector2d max = this.points[0];
            for (int i = 1; i < this.points.length; ++i) {
                max = max.max(this.points[i]);
            }
            this.max = max;
        }
        return this.max;
    }

    public static Shape createRect(Vector2d pos1, Vector2d pos2) {
        Vector2d min2 = pos1.min(pos2);
        Vector2d max = pos1.max(pos2);
        return new Shape(min2, new Vector2d(max.getX(), min2.getY()), max, new Vector2d(min2.getX(), max.getY()));
    }

    public static Shape createRect(double x1, double y1, double x2, double y2) {
        return Shape.createRect(new Vector2d(x1, y1), new Vector2d(x2, y2));
    }

    public static Shape createEllipse(Vector2d centerPos, double radiusX, double radiusY, int points) {
        if (points < 3) {
            throw new IllegalArgumentException("A shape has to have at least 3 points!");
        }
        Vector2d[] pointArray = new Vector2d[points];
        double segmentAngle = Math.PI * 2 / (double)points;
        double angle = 0.0;
        for (int i = 0; i < points; ++i) {
            pointArray[i] = centerPos.add(Math.sin(angle) * radiusX, Math.cos(angle) * radiusY);
            angle += segmentAngle;
        }
        return new Shape(pointArray);
    }

    public static Shape createEllipse(double centerX, double centerY, double radiusX, double radiusY, int points) {
        return Shape.createEllipse(new Vector2d(centerX, centerY), radiusX, radiusY, points);
    }

    public static Shape createCircle(Vector2d centerPos, double radius, int points) {
        return Shape.createEllipse(centerPos, radius, radius, points);
    }

    public static Shape createCircle(double centerX, double centerY, double radius, int points) {
        return Shape.createCircle(new Vector2d(centerX, centerY), radius, points);
    }
}

