/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.marker;

import com.flowpowered.math.vector.Vector3d;
import java.util.Arrays;

public class Line {
    private final Vector3d[] points;
    private Vector3d min = null;
    private Vector3d max = null;

    public Line(Vector3d ... points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("A line has to have at least 2 points!");
        }
        this.points = points;
    }

    public int getPointCount() {
        return this.points.length;
    }

    public Vector3d getPoint(int i) {
        return this.points[i];
    }

    public Vector3d[] getPoints() {
        return Arrays.copyOf(this.points, this.points.length);
    }

    public Vector3d getMin() {
        if (this.min == null) {
            Vector3d min2 = this.points[0];
            for (int i = 1; i < this.points.length; ++i) {
                min2 = min2.min(this.points[i]);
            }
            this.min = min2;
        }
        return this.min;
    }

    public Vector3d getMax() {
        if (this.max == null) {
            Vector3d max = this.points[0];
            for (int i = 1; i < this.points.length; ++i) {
                max = max.max(this.points[i]);
            }
            this.max = max;
        }
        return this.max;
    }
}

