/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api;

import de.bluecolored.bluemap.api.BlueMapAPIListener;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.renderer.RenderAPI;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public abstract class BlueMapAPI {
    private static BlueMapAPI instance;
    @Deprecated
    private static final Collection<BlueMapAPIListener> listener;
    private static final Collection<Consumer<BlueMapAPI>> onEnableConsumers;
    private static final Collection<Consumer<BlueMapAPI>> onDisableConsumers;

    public abstract RenderAPI getRenderAPI();

    public abstract MarkerAPI getMarkerAPI() throws IOException;

    public abstract Collection<BlueMapMap> getMaps();

    public abstract Collection<BlueMapWorld> getWorlds();

    public abstract Optional<BlueMapWorld> getWorld(UUID var1);

    public abstract Optional<BlueMapMap> getMap(String var1);

    public abstract String createImage(BufferedImage var1, String var2) throws IOException;

    public abstract Map<String, String> availableImages() throws IOException;

    public abstract Path getWebRoot();

    public abstract String getBlueMapVersion();

    @Deprecated
    public static synchronized void registerListener(BlueMapAPIListener listener) {
        BlueMapAPI.listener.add(listener);
        if (instance != null) {
            listener.onEnable(instance);
        }
    }

    @Deprecated
    public static synchronized boolean unregisterListener(BlueMapAPIListener listener) {
        return BlueMapAPI.listener.remove(listener);
    }

    public static synchronized Optional<BlueMapAPI> getInstance() {
        return Optional.ofNullable(instance);
    }

    public static synchronized void onEnable(Consumer<BlueMapAPI> consumer) {
        onEnableConsumers.add(consumer);
        if (instance != null) {
            consumer.accept(instance);
        }
    }

    public static synchronized void onDisable(Consumer<BlueMapAPI> consumer) {
        onDisableConsumers.add(consumer);
    }

    public static synchronized boolean unregisterListener(Consumer<BlueMapAPI> consumer) {
        return onEnableConsumers.remove(consumer) | onDisableConsumers.remove(consumer);
    }

    /*
     * WARNING - void declaration
     */
    protected static synchronized boolean registerInstance(BlueMapAPI instance) throws ExecutionException {
        if (BlueMapAPI.instance != null) {
            return false;
        }
        BlueMapAPI.instance = instance;
        ArrayList<Throwable> thrownExceptions = new ArrayList<Throwable>(0);
        for (Consumer<BlueMapAPI> consumer : onEnableConsumers) {
            try {
                consumer.accept(BlueMapAPI.instance);
            }
            catch (Throwable ex) {
                thrownExceptions.add(ex);
            }
        }
        for (BlueMapAPIListener blueMapAPIListener : listener) {
            try {
                blueMapAPIListener.onEnable(BlueMapAPI.instance);
            }
            catch (Throwable ex) {
                thrownExceptions.add(ex);
            }
        }
        if (!thrownExceptions.isEmpty()) {
            void var3_7;
            ExecutionException ex = new ExecutionException((Throwable)thrownExceptions.get(0));
            boolean bl = true;
            while (var3_7 < thrownExceptions.size()) {
                ex.addSuppressed((Throwable)thrownExceptions.get((int)var3_7));
                ++var3_7;
            }
            throw ex;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static synchronized boolean unregisterInstance(BlueMapAPI instance) throws ExecutionException {
        if (BlueMapAPI.instance != instance) {
            return false;
        }
        ArrayList<Exception> thrownExceptions = new ArrayList<Exception>(0);
        for (Consumer<BlueMapAPI> consumer : onDisableConsumers) {
            try {
                consumer.accept(BlueMapAPI.instance);
            }
            catch (Exception ex) {
                thrownExceptions.add(ex);
            }
        }
        for (BlueMapAPIListener blueMapAPIListener : listener) {
            try {
                blueMapAPIListener.onDisable(BlueMapAPI.instance);
            }
            catch (Exception ex) {
                thrownExceptions.add(ex);
            }
        }
        BlueMapAPI.instance = null;
        if (!thrownExceptions.isEmpty()) {
            void var3_7;
            ExecutionException ex = new ExecutionException((Throwable)thrownExceptions.get(0));
            boolean bl = true;
            while (var3_7 < thrownExceptions.size()) {
                ex.addSuppressed((Throwable)thrownExceptions.get((int)var3_7));
                ++var3_7;
            }
            throw ex;
        }
        return true;
    }

    static {
        listener = new HashSet<BlueMapAPIListener>(2);
        onEnableConsumers = new HashSet<Consumer<BlueMapAPI>>(2);
        onDisableConsumers = new HashSet<Consumer<BlueMapAPI>>(2);
    }
}

