/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EditConfigScreen
extends BaseScreen {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba(-1724697805);
    public static Theme THEME = new Theme(){

        @Override
        public void drawScrollBarBackground(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.withAlpha(70).draw(matrixStack, x, y, w, h);
        }

        @Override
        public void drawScrollBar(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(WidgetType.NORMAL).withAlpha(100).withBorder(Color4I.GRAY.withAlpha(100), false).draw(matrixStack, x, y, w, h);
        }
    };
    private final ConfigGroup group;
    private final ITextComponent title;
    private final List<Widget> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int groupSize = 0;

    public EditConfigScreen(ConfigGroup g) {
        this.group = g;
        this.title = g.getName().func_230532_e_().func_240699_a_(TextFormatting.BOLD);
        this.configEntryButtons = new ArrayList<Widget>();
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (Widget w : EditConfigScreen.this.configEntryButtons) {
                    if (w instanceof ConfigEntryButton && ((ConfigEntryButton)w).group.collapsed) continue;
                    this.add(w);
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                EditConfigScreen.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        ArrayList<ConfigValue> list = new ArrayList<ConfigValue>();
        this.collectAllConfigValues(this.group, list);
        if (!list.isEmpty()) {
            list.sort(null);
            ConfigGroupButton group = null;
            for (ConfigValue value : list) {
                if (group == null || group.group != value.group) {
                    group = new ConfigGroupButton(this.configPanel, value.group);
                    this.configEntryButtons.add(group);
                    ++this.groupSize;
                }
                this.configEntryButtons.add(new ConfigEntryButton(this.configPanel, group, value));
            }
            if (this.groupSize == 1) {
                this.configEntryButtons.remove(group);
            }
        }
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.close"), Icons.ACCEPT, (widget, button) -> this.group.save(true));
        this.buttonCancel = new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.cancel"), Icons.CANCEL, (widget, button) -> this.group.save(false));
        this.buttonExpandAll = new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.expand_all"), Icons.ADD, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ConfigGroupButton)) continue;
                ((ConfigGroupButton)w).setCollapsed(false);
            }
            this.scroll.setValue(0.0);
            widget.getGui().refreshWidgets();
        });
        this.buttonCollapseAll = new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.collapse_all"), Icons.REMOVE, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ConfigGroupButton)) continue;
                ((ConfigGroupButton)w).setCollapsed(true);
            }
            this.scroll.setValue(0.0);
            widget.getGui().refreshWidgets();
        });
    }

    private void collectAllConfigValues(ConfigGroup group, List<ConfigValue> list) {
        list.addAll(group.getValues());
        for (ConfigGroup group1 : group.getGroups()) {
            this.collectAllConfigValues(group1, list);
        }
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        if (this.groupSize > 1) {
            this.add(this.buttonExpandAll);
            this.add(this.buttonCollapseAll);
        }
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
        if (this.groupSize > 1) {
            this.buttonExpandAll.setPos(this.width - 58, 2);
            this.buttonCollapseAll.setPos(this.width - 78, 2);
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.group.save(true);
            return false;
        }
        return false;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        COLOR_BACKGROUND.draw(matrixStack, 0, 0, w, 20);
        theme.drawString(matrixStack, this.getTitle(), 6, 6, 2);
    }

    @Override
    public ITextComponent getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return THEME;
    }

    public class ConfigGroupButton
    extends Button {
        public final ConfigGroup group;
        public IFormattableTextComponent title;
        public IFormattableTextComponent info;
        public boolean collapsed;

        public ConfigGroupButton(Panel panel, ConfigGroup g) {
            String infoKey;
            super(panel);
            this.collapsed = false;
            this.setHeight(12);
            this.group = g;
            if (this.group.parent != null) {
                ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
                g = this.group;
                do {
                    groups.add(g);
                } while ((g = g.parent) != null);
                groups.remove(groups.size() - 1);
                this.title = new StringTextComponent("");
                for (int i = groups.size() - 1; i >= 0; --i) {
                    this.title.func_230529_a_(((ConfigGroup)groups.get(i)).getName());
                    if (i == 0) continue;
                    this.title.func_240702_b_(" > ");
                }
            } else {
                this.title = new TranslationTextComponent("stat.generalButton");
            }
            this.info = I18n.func_188566_a((String)(infoKey = this.group.getPath() + ".info")) ? new TranslationTextComponent(infoKey) : null;
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean v) {
            this.collapsed = v;
            this.setTitle((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new StringTextComponent(this.collapsed ? "[-] " : "[v] ").func_240699_a_(this.collapsed ? TextFormatting.RED : TextFormatting.GREEN)).func_230529_a_((ITextComponent)this.title));
        }

        @Override
        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            COLOR_BACKGROUND.draw(matrixStack, x, y, w, h);
            theme.drawString(matrixStack, this.getTitle(), x + 2, y + 2);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.info != null) {
                list.add((ITextComponent)this.info);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }
    }

    private class ConfigEntryButton
    extends Button {
        public final ConfigGroupButton group;
        public final ConfigValue inst;
        public ITextComponent keyText;

        public ConfigEntryButton(Panel panel, ConfigGroupButton g, ConfigValue i) {
            super(panel);
            this.setHeight(12);
            this.group = g;
            this.inst = i;
            this.keyText = !this.inst.getCanEdit() ? new StringTextComponent(this.inst.getName()).func_240699_a_(TextFormatting.GRAY) : new StringTextComponent(this.inst.getName());
        }

        @Override
        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
            theme.drawString(matrixStack, this.keyText, x + 4, y + 2, Bits.setFlag(0, 2, mouseOver));
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ITextComponent s = this.inst.getStringForGUI(this.inst.value);
            int slen = theme.getStringWidth((ITextProperties)s);
            if (slen > 150) {
                s = new StringTextComponent(theme.trimStringToWidth((ITextProperties)s, 150).getString().trim() + "...");
                slen = 152;
            }
            MutableColor4I textCol = this.inst.getColor(this.inst.value).mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (this.getMouseX() > x + w - slen - 9) {
                    Color4I.WHITE.withAlpha(33).draw(matrixStack, x + w - slen - 8, y, slen + 8, h);
                }
            }
            theme.drawString(matrixStack, s, this.getGui().width - (slen + 20), y + 2, textCol, 0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseY() >= 20) {
                this.playClickSound();
                this.inst.onClicked(button, accepted -> this.run());
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.getMouseY() > 18) {
                list.add((ITextComponent)this.keyText.func_230532_e_().func_240699_a_(TextFormatting.UNDERLINE));
                String tooltip = this.inst.getTooltip();
                if (!tooltip.isEmpty()) {
                    for (String s : tooltip.split("\n")) {
                        list.styledString(s, Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY)));
                    }
                }
                list.blankLine();
                this.inst.addInfo(list);
            }
        }
    }
}

