/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.camels.entities;

import com.talhanation.camels.entities.ai.goal.CamelFollowCaravanGoal;
import com.talhanation.camels.init.ModEntityTypes;
import com.talhanation.camels.init.SoundInit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CamelEntity
extends LlamaEntity {
    private static final Ingredient BreedItems;
    private static final DataParameter<Integer> DATA_STRENGTH_ID;
    private static final DataParameter<Integer> DATA_COLOR_ID;
    private static final DataParameter<Integer> DATA_VARIANT_ID;
    public int field_110278_bp;
    @Nullable
    private CamelEntity caravanHead;
    @Nullable
    private CamelEntity caravanTail;

    protected void func_230273_eI_() {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.func_110267_cL());
    }

    protected float func_110267_cL() {
        return 25.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    public CamelEntity(EntityType<? extends CamelEntity> type, World world) {
        super(type, world);
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return BreedItems.test(itemStack);
    }

    private void setStrength(int x) {
        this.field_70180_af.func_187227_b(DATA_STRENGTH_ID, (Object)Math.max(2, Math.min(10, x)));
    }

    private void setRandomStrength() {
        int x = this.field_70146_Z.nextFloat() < 0.04f ? 5 : 3;
        this.setStrength(5 + this.field_70146_Z.nextInt(x));
    }

    public int func_190707_dL() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_STRENGTH_ID);
    }

    public void func_213281_b(CompoundNBT comnbt) {
        super.func_213281_b(comnbt);
        comnbt.func_74768_a("Variant", this.func_190719_dM());
        comnbt.func_74768_a("Strength", this.func_190707_dL());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            comnbt.func_218657_a("DecorItem", (INBT)this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT comnbt) {
        this.setStrength(comnbt.func_74762_e("Strength"));
        super.func_70037_a(comnbt);
        this.func_190710_o(comnbt.func_74762_e("Variant"));
        if (comnbt.func_150297_b("DecorItem", 10)) {
            this.field_110296_bG.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)comnbt.func_74775_l("DecorItem")));
        }
        this.func_230275_fc_();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new CamelFollowCaravanGoal(this, 2.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.17f).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233830_m_, (double)0.33f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_STRENGTH_ID, (Object)0);
        this.field_70180_af.func_187214_a(DATA_COLOR_ID, (Object)-1);
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
    }

    public int func_190719_dM() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID)), (int)0, (int)4);
    }

    public void func_190710_o(int variant) {
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)variant);
    }

    protected int func_190686_di() {
        return this.func_190695_dh() ? 2 + 5 * this.func_190696_dl() : super.func_190686_di();
    }

    @Nullable
    public void func_184232_k(Entity entity) {
        if (this.func_184196_w(entity)) {
            float x = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float y = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float z = 0.3f;
            entity.func_70107_b(this.func_226277_ct_() + (double)(0.3f * y), this.func_226278_cu_() + this.func_70042_X() + entity.func_70033_W(), this.func_226281_cx_() - (double)(0.3f * x));
        }
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.78;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public ActionResultType func_241395_b_(PlayerEntity p_241395_1_, ItemStack p_241395_2_) {
        boolean flag = this.func_190678_b(p_241395_1_, p_241395_2_);
        if (!p_241395_1_.field_71075_bZ.field_75098_d) {
            p_241395_2_.func_190918_g(1);
        }
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        return flag ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    protected boolean func_190678_b(PlayerEntity playerEntity, ItemStack itemStack) {
        SoundEvent lvt_8_1_;
        int i = 0;
        int j = 0;
        float f = 0.0f;
        boolean b = false;
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151015_O) {
            i = 10;
            j = 3;
            f = 2.0f;
        } else if (item == Items.field_151102_aT) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (item == Items.field_151034_e) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (item == Blocks.field_150407_cf.func_199767_j()) {
            i = 90;
            j = 6;
            f = 10.0f;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && this.func_204701_dC()) {
                b = true;
                this.func_146082_f(playerEntity);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            b = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            b = true;
        }
        if (j > 0 && (b || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            b = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(j);
            }
        }
        if (b && !this.func_174814_R() && (lvt_8_1_ = this.func_230274_fe_()) != null) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_230274_fe_(), this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        return b;
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_110204_cc();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance diff, SpawnReason spawn, @Nullable ILivingEntityData data, @Nullable CompoundNBT comnbt) {
        int x;
        this.setRandomStrength();
        if (data instanceof CamelData) {
            x = ((CamelData)((Object)data)).variant;
        } else {
            x = this.field_70146_Z.nextInt(4);
            data = new CamelData(x);
        }
        this.func_190710_o(x);
        return super.func_213386_a(world, diff, spawn, data, comnbt);
    }

    protected SoundEvent func_184785_dv() {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_ANGRY_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_ANGRY.get();
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_AMBIENT_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_HURT_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_DEATH_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_DEATH.get();
    }

    protected void func_180429_a(BlockPos blockpos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    protected void func_190697_dk() {
        this.func_184185_a(SoundEvents.field_191259_dX, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public int func_190696_dl() {
        return this.func_190707_dL();
    }

    public boolean func_230276_fq_() {
        return true;
    }

    public boolean func_190682_f(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return ItemTags.field_200035_e.func_230235_a_((Object)item);
    }

    public boolean func_230264_L__() {
        return true;
    }

    public void func_76316_a(IInventory inventory) {
        DyeColor dye1 = this.func_190704_dO();
        super.func_76316_a(inventory);
        DyeColor dye2 = this.func_190704_dO();
        if (this.field_70173_aa <= 20 || dye2 == null || dye2 != dye1) {
            // empty if block
        }
    }

    protected void func_230275_fc_() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_230275_fc_();
            this.setColor(CamelEntity.getCarpetColor(this.field_110296_bG.func_70301_a(1)));
        }
    }

    private void setColor(@Nullable DyeColor dye) {
        this.field_70180_af.func_187227_b(DATA_COLOR_ID, (Object)(dye == null ? -1 : dye.func_196059_a()));
    }

    @Nullable
    private static DyeColor getCarpetColor(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        return block instanceof CarpetBlock ? ((CarpetBlock)block).func_196547_d() : null;
    }

    @Nullable
    public DyeColor func_190704_dO() {
        int x = (Integer)this.field_70180_af.func_187225_a(DATA_COLOR_ID);
        return x == -1 ? null : DyeColor.func_196056_a((int)x);
    }

    public int func_190676_dC() {
        return 60;
    }

    public boolean func_70878_b(AnimalEntity animal) {
        return animal != this && animal instanceof CamelEntity && this.func_110200_cJ() && ((CamelEntity)animal).func_110200_cJ();
    }

    public CamelEntity func_241840_a(ServerWorld serverWorld, AgeableEntity parent) {
        CamelEntity camelEntity = this.createChild();
        this.func_190681_a(parent, (AbstractHorseEntity)camelEntity);
        CamelEntity camelEntity1 = (CamelEntity)parent;
        int i = this.field_70146_Z.nextInt(Math.max(this.func_190707_dL(), camelEntity1.func_190707_dL())) + 1;
        if (this.field_70146_Z.nextFloat() < 0.03f) {
            ++i;
        }
        camelEntity.setStrength(i);
        camelEntity.func_190710_o(this.field_70146_Z.nextBoolean() ? this.func_190719_dM() : camelEntity1.func_190719_dM());
        return camelEntity;
    }

    protected CamelEntity createChild() {
        return (CamelEntity)((EntityType)ModEntityTypes.CAMEL_ENTITY.get()).func_200721_a(this.field_70170_p);
    }

    public boolean func_225503_b_(float x, float y) {
        int z = this.func_225508_e_(x, y);
        if (z <= 0) {
            return false;
        }
        if (x >= 6.0f) {
            this.func_70097_a(DamageSource.field_76379_h, z);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, (float)z);
                }
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    public void func_190709_dP() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(CamelEntity entity) {
        this.caravanHead = entity;
        this.caravanHead.caravanTail = this;
    }

    public boolean func_190712_dQ() {
        return this.caravanTail != null;
    }

    public boolean func_190718_dR() {
        return this.caravanHead != null;
    }

    @Nullable
    public CamelEntity getCaravanHead() {
        return this.caravanHead;
    }

    protected double func_190634_dg() {
        return 1.5;
    }

    protected void func_190679_dD() {
        if (!this.func_190718_dR() && this.func_70631_g_()) {
            super.func_190679_dD();
        }
    }

    public boolean func_190684_dE() {
        return false;
    }

    public void func_70636_d() {
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            this.func_190679_dD();
        }
    }

    private void moveTail() {
        this.field_110278_bp = 1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 1.3f;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.75f : 1.85f;
    }

    static {
        DATA_STRENGTH_ID = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        DATA_COLOR_ID = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        DATA_VARIANT_ID = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        BreedItems = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O, Blocks.field_150407_cf.func_199767_j()});
    }

    static class CamelData
    extends AgeableEntity.AgeableData {
        public final int variant;

        private CamelData(int x) {
            super(true);
            this.variant = x;
        }
    }
}

