/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import mrp_v2.mrplibrary.util.IModLocProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ParticleProvider
implements IDataProvider,
IModLocProvider {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public final String modId;
    private final DataGenerator generator;

    protected ParticleProvider(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    public static ParticleBuilder makeBuilder(ResourceLocation location) {
        return new ParticleBuilder(location);
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet locationSet = new HashSet();
        this.registerParticles(particleBuilder -> {
            if (!locationSet.add(particleBuilder.getLocation())) {
                throw new IllegalStateException("Duplicate recipe " + particleBuilder.getLocation());
            }
            this.saveParticle(cache, particleBuilder.toJson(), path.resolve("assets/" + particleBuilder.getLocation().func_110624_b() + "/particles/" + particleBuilder.getLocation().func_110623_a() + ".json"));
        });
    }

    protected abstract void registerParticles(Consumer<ParticleBuilder> var1);

    public String func_200397_b() {
        return "Particles: " + this.modId;
    }

    private void saveParticle(DirectoryCache cache, JsonObject particle, Path path) {
        try {
            String json = GSON.toJson((JsonElement)particle);
            String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(json);
                }
            }
            cache.func_208316_a(path, hash);
        }
        catch (IOException ioException) {
            LOGGER.error("Couldn't save particle {}", (Object)path, (Object)ioException);
        }
    }

    public static class ParticleBuilder {
        private final ResourceLocation location;
        private final Set<ResourceLocation> textures;

        private ParticleBuilder(ResourceLocation location) {
            this.location = location;
            this.textures = new HashSet<ResourceLocation>();
        }

        public ResourceLocation getLocation() {
            return this.location;
        }

        public ParticleBuilder addTextures(ResourceLocation ... textures) {
            for (ResourceLocation texture : textures) {
                this.addTexture(texture);
            }
            return this;
        }

        public ParticleBuilder addTexture(ResourceLocation texture) {
            this.textures.add(texture);
            return this;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            if (this.textures.size() > 0) {
                JsonArray array = new JsonArray();
                for (ResourceLocation texture : this.textures) {
                    array.add(texture.toString());
                }
                json.add("textures", (JsonElement)array);
            }
            return json;
        }
    }
}

