/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen;

import java.util.HashMap;
import javax.annotation.Nonnull;
import mrp_v2.mrplibrary.datagen.providers.BlockStateProvider;
import mrp_v2.mrplibrary.datagen.providers.util.ModelJsonParser;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TintedBlockStateGenerator
extends BlockStateProvider {
    @Deprecated
    public static final String SUBSTITUTE = "#";
    @Deprecated
    public static final String PARTICLE = "particle";
    @Deprecated
    public static final String BOTTOM_BASE = "bottom";
    @Deprecated
    public static final String BOTTOM = "#bottom";
    @Deprecated
    public static final String TOP = "#top";
    @Deprecated
    public static final String SIDE = "#side";
    @Deprecated
    public static final String END = "#end";
    @Deprecated
    public static final String FRONT = "#front";
    @Deprecated
    public static final String WALL = "#wall";
    @Deprecated
    public static final String TEXTURE = "#texture";
    @Deprecated
    public static final String ALL = "#all";
    @Deprecated
    public static final ResourceLocation BASE_BLOCK = new ResourceLocation("block/block");
    @Deprecated
    public static final ResourceLocation CUBE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube");
    public static final ResourceLocation CUBE_ALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_all");
    public static final ResourceLocation CUBE_BOTTOM_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_bottom_top");
    public static final ResourceLocation CUBE_COLUMN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_column");
    public static final ResourceLocation CUBE_COLUMN_HORIZONTAL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_column_horizontal_tinted");
    public static final ResourceLocation CUBE_DIRECTIONAL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_directional");
    public static final ResourceLocation CUBE_MIRRORED_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_mirrored");
    public static final ResourceLocation CUBE_MIRRORED_ALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_mirrored_all");
    public static final ResourceLocation CUBE_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_top");
    public static final ResourceLocation FENCE_GATE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate");
    public static final ResourceLocation FENCE_GATE_OPEN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate_open");
    public static final ResourceLocation FENCE_GATE_WALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate_wall");
    public static final ResourceLocation FENCE_GATE_WALL_OPEN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate_wall_open");
    public static final ResourceLocation FENCE_INVENTORY_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_inventory");
    public static final ResourceLocation FENCE_POST_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_post");
    public static final ResourceLocation FENCE_SIDE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_side");
    public static final ResourceLocation ORIENTABLE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("orientable");
    public static final ResourceLocation ORIENTABLE_VERTICAL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("orientable_vertical");
    public static final ResourceLocation ORIENTABLE_WITH_BOTTOM_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("orientable_with_bottom");
    public static final ResourceLocation SLAB_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("slab");
    public static final ResourceLocation SLAB_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("slab_top");
    public static final ResourceLocation STAIRS_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("stairs");
    public static final ResourceLocation STAIRS_INNER_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("stairs_inner");
    public static final ResourceLocation STAIRS_OUTER_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("stairs_outer");
    public static final ResourceLocation WALL_INVENTORY_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_inventory");
    public static final ResourceLocation WALL_POST_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_post");
    public static final ResourceLocation WALL_SIDE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_side");
    public static final ResourceLocation WALL_SIDE_TALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_side_tall");
    public static final ResourceLocation TEMPLATE_ORIENTABLE_TRAPDOOR_BOTTOM_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("template_orientable_trapdoor_bottom");
    public static final ResourceLocation TEMPLATE_ORIENTABLE_TRAPDOOR_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("template_orientable_trapdoor_top");
    public static final ResourceLocation TEMPLATE_ORIENTABLE_TRAPDOOR_OPEN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("template_orientable_trapdoor_open");
    public static final ResourceLocation TEMPLATE_TRAPDOOR_BOTTOM_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("template_trapdoor_bottom");
    public static final ResourceLocation TEMPLATE_TRAPDOOR_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("template_trapdoor_top");
    public static final ResourceLocation TEMPLATE_TRAPDOOR_OPEN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("template_trapdoor_open");
    public static final HashMap<Direction, Pair<Integer, Integer>> FACE_ROTATION_MAP = new HashMap();
    public final ModelJsonParser parser = new ModelJsonParser(this.models());

    public TintedBlockStateGenerator(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    private static ResourceLocation makeTintedBlockLoc(String loc) {
        return TintedBlockStateGenerator.makeBlockLoc(loc + "_tinted");
    }

    private static ResourceLocation makeBlockLoc(String loc) {
        return new ResourceLocation("mrplibrary", "block/" + loc);
    }

    protected void registerStatesAndModels() {
        this.registerFullBlockModels();
        this.registerSlabModels();
        this.registerStairModels();
        this.registerFenceModels();
        this.registerFenceGateModels();
        this.registerWallModels();
        this.registerTrapDoorModels();
    }

    @Nonnull
    public String func_200397_b() {
        return super.func_200397_b() + ": Tinted Blocks";
    }

    private void registerTrapDoorModels() {
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_orientable_trapdoor_bottom"), TEMPLATE_ORIENTABLE_TRAPDOOR_BOTTOM_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_orientable_trapdoor_open"), TEMPLATE_ORIENTABLE_TRAPDOOR_OPEN_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_orientable_trapdoor_top"), TEMPLATE_ORIENTABLE_TRAPDOOR_TOP_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_trapdoor_bottom"), TEMPLATE_TRAPDOOR_BOTTOM_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_trapdoor_open"), TEMPLATE_TRAPDOOR_OPEN_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_trapdoor_top"), TEMPLATE_TRAPDOOR_TOP_TINTED), this::addTintsToElement);
    }

    private void registerFenceModels() {
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("fence_inventory"), FENCE_INVENTORY_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("fence_post"), FENCE_POST_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("fence_side"), FENCE_SIDE_TINTED), this::addTintsToElement);
    }

    private void registerFenceGateModels() {
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_fence_gate"), FENCE_GATE_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_fence_gate_open"), FENCE_GATE_OPEN_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_fence_gate_wall"), FENCE_GATE_WALL_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_fence_gate_wall_open"), FENCE_GATE_WALL_OPEN_TINTED), this::addTintsToElement);
    }

    private void registerFullBlockModels() {
        ModelBuilder<BlockModelBuilder> cubeTinted = this.forEachElement(this.parser.buildBlockModel(this.mcLoc("cube"), CUBE_TINTED), this::addTintsToElement);
        this.parser.buildBlockModel(this.mcLoc("cube_all"), CUBE_ALL_TINTED).parent(cubeTinted);
        this.parser.buildBlockModel(this.mcLoc("cube_bottom_top"), CUBE_BOTTOM_TOP_TINTED).parent(cubeTinted);
        this.parser.buildBlockModel(this.mcLoc("cube_column"), CUBE_COLUMN_TINTED).parent(cubeTinted);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("cube_column_horizontal"), CUBE_COLUMN_HORIZONTAL_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("cube_directional"), CUBE_DIRECTIONAL_TINTED), this::addTintsToElement);
        ModelBuilder<BlockModelBuilder> cubeMirroredTinted = this.forEachElement(this.parser.buildBlockModel(this.mcLoc("cube_mirrored"), CUBE_MIRRORED_TINTED), this::addTintsToElement);
        this.parser.buildBlockModel(this.mcLoc("cube_mirrored_all"), CUBE_MIRRORED_ALL_TINTED).parent(cubeMirroredTinted);
        this.parser.buildBlockModel(this.mcLoc("cube_top"), CUBE_TOP_TINTED).parent(cubeTinted);
        ModelBuilder orientableWithBottom = this.parser.buildBlockModel(this.mcLoc("orientable_with_bottom"), ORIENTABLE_WITH_BOTTOM_TINTED).parent(cubeTinted);
        this.parser.buildBlockModel(this.mcLoc("orientable"), ORIENTABLE_TINTED).parent((ModelFile)orientableWithBottom);
        this.parser.buildBlockModel(this.mcLoc("orientable_vertical"), ORIENTABLE_VERTICAL_TINTED).parent(cubeTinted);
    }

    protected <T extends ModelBuilder<T>> void addTintsToElement(ModelBuilder.ElementBuilder builder) {
        builder.faces(this::addTintsToFace);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected void addTintsToFace(Direction dir, ModelBuilder.ElementBuilder.FaceBuilder faceBuilder) {
        faceBuilder.tintindex(0);
    }

    private void registerWallModels() {
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("wall_inventory"), WALL_INVENTORY_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_wall_post"), WALL_POST_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_wall_side"), WALL_SIDE_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("template_wall_side_tall"), WALL_SIDE_TALL_TINTED), this::addTintsToElement);
    }

    private void registerSlabModels() {
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("slab"), SLAB_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("slab_top"), SLAB_TOP_TINTED), this::addTintsToElement);
    }

    private void registerStairModels() {
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("stairs"), STAIRS_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("inner_stairs"), STAIRS_INNER_TINTED), this::addTintsToElement);
        this.forEachElement(this.parser.buildBlockModel(this.mcLoc("outer_stairs"), STAIRS_OUTER_TINTED), this::addTintsToElement);
    }

    static {
        FACE_ROTATION_MAP.put(Direction.NORTH, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)0));
        FACE_ROTATION_MAP.put(Direction.EAST, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)90));
        FACE_ROTATION_MAP.put(Direction.SOUTH, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)180));
        FACE_ROTATION_MAP.put(Direction.WEST, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)-90));
        FACE_ROTATION_MAP.put(Direction.UP, (Pair<Integer, Integer>)Pair.of((Object)-90, (Object)0));
        FACE_ROTATION_MAP.put(Direction.DOWN, (Pair<Integer, Integer>)Pair.of((Object)90, (Object)0));
    }

    @Deprecated
    public static class Util {
        @Deprecated
        public static void fenceGateElements(ModelBuilder<BlockModelBuilder> builder, boolean isOpen, Wall wall) {
        }

        @Deprecated
        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1, float v1, float u2, float v2, Direction ... directions) {
            for (Direction direction : directions) {
                builder.face(direction).uvs(u1, v1, u2, v2);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        @Deprecated
        public static void textureFunction(Direction direction, ModelBuilder.ElementBuilder.FaceBuilder faceBuilder) {
            faceBuilder.texture(TintedBlockStateGenerator.TEXTURE);
        }

        @Deprecated
        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1t, float u1f, float v1t, float v1f, float u2t, float u2f, float v2t, float v2f, boolean condition, Direction ... directions) {
            for (Direction direction : directions) {
                if (condition) {
                    builder.face(direction).uvs(u1t, v1t, u2t, v2t);
                    continue;
                }
                builder.face(direction).uvs(u1f, v1f, u2f, v2f);
            }
        }

        @Deprecated
        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1t, float u1f, float v1, float u2t, float u2f, float v2, boolean condition, Direction ... directions) {
            for (Direction direction : directions) {
                if (condition) {
                    builder.face(direction).uvs(u1t, v1, u2t, v2);
                    continue;
                }
                builder.face(direction).uvs(u1f, v1, u2f, v2);
            }
        }

        @Deprecated
        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1t, float u1f, float v1, float u2t, float u2f, float v2, boolean condition) {
            builder.faces((direction, faceBuilder) -> {
                if (condition) {
                    faceBuilder.uvs(u1t, v1, u2t, v2);
                } else {
                    faceBuilder.uvs(u1f, v1, u2f, v2);
                }
            });
        }

        @Deprecated
        public static float applyWall(float base, boolean isWall) {
            return isWall ? base - 3.0f : base;
        }

        @Deprecated
        public static class Wall {
            private final boolean isWall;

            @Deprecated
            public Wall(boolean isWall) {
                this.isWall = isWall;
            }

            @Deprecated
            public float apply(float f) {
                return Util.applyWall(f, this.isWall);
            }
        }
    }
}

