/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen;

import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mrp_v2.mrplibrary.datagen.BlockLootTables;
import mrp_v2.mrplibrary.datagen.providers.BlockTagsProvider;
import mrp_v2.mrplibrary.datagen.providers.ItemTagsProvider;
import mrp_v2.mrplibrary.datagen.providers.LootTableProvider;
import mrp_v2.mrplibrary.datagen.providers.ParticleProvider;
import mrp_v2.mrplibrary.datagen.providers.RecipeProvider;
import mrp_v2.mrplibrary.datagen.providers.TextureProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.LootTable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

public class DataGeneratorHelper {
    private final DataGenerator dataGenerator;
    private final String modId;
    private final ExistingFileHelper existingFileHelper;
    private final net.minecraft.data.BlockTagsProvider blockTagsProvider;
    private final boolean includeClient;
    private final boolean includeServer;

    public DataGeneratorHelper(GatherDataEvent event, String modId) {
        this.dataGenerator = event.getGenerator();
        this.modId = modId;
        this.existingFileHelper = event.getExistingFileHelper();
        this.blockTagsProvider = new net.minecraft.data.BlockTagsProvider(this.dataGenerator, this.modId, this.existingFileHelper);
        this.includeClient = event.includeClient();
        this.includeServer = event.includeServer();
    }

    public void addTextureProvider(Function3<DataGenerator, ExistingFileHelper, String, ? extends TextureProvider> textureProviderConstructor) {
        if (this.includeClient) {
            this.dataGenerator.func_200390_a((IDataProvider)textureProviderConstructor.apply((Object)this.dataGenerator, (Object)this.existingFileHelper, (Object)this.modId));
        }
    }

    public void addParticleProvider(BiFunction<DataGenerator, String, ? extends ParticleProvider> particleProviderConstructor) {
        if (this.includeClient) {
            this.dataGenerator.func_200390_a((IDataProvider)particleProviderConstructor.apply(this.dataGenerator, this.modId));
        }
    }

    public void addLootTableProvider(Function3<DataGenerator, Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, String, ? extends LootTableProvider> lootTableProviderConstructor, Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>> lootTablesProvider) {
        if (this.includeServer) {
            this.dataGenerator.func_200390_a((IDataProvider)lootTableProviderConstructor.apply((Object)this.dataGenerator, lootTablesProvider, (Object)this.modId));
        }
    }

    public void addLootTables(BlockLootTables blockLootTables) {
        if (this.includeServer) {
            this.dataGenerator.func_200390_a((IDataProvider)new LootTableProvider(this.dataGenerator, blockLootTables, this.modId));
        }
    }

    public void addRecipeProvider(BiFunction<DataGenerator, String, ? extends RecipeProvider> recipeProviderConstructor) {
        if (this.includeServer) {
            this.dataGenerator.func_200390_a((IDataProvider)recipeProviderConstructor.apply(this.dataGenerator, this.modId));
        }
    }

    public void addItemTagsProvider(Function4<DataGenerator, net.minecraft.data.BlockTagsProvider, String, ExistingFileHelper, ? extends ItemTagsProvider> itemTagsProviderConstructor) {
        if (this.includeServer) {
            this.dataGenerator.func_200390_a((IDataProvider)itemTagsProviderConstructor.apply((Object)this.dataGenerator, (Object)this.blockTagsProvider, (Object)this.modId, (Object)this.existingFileHelper));
        }
    }

    public void addBlockTagsProvider(Function3<DataGenerator, String, ExistingFileHelper, ? extends BlockTagsProvider> blockTagsProviderConstructor) {
        if (this.includeServer) {
            this.dataGenerator.func_200390_a((IDataProvider)blockTagsProviderConstructor.apply((Object)this.dataGenerator, (Object)this.modId, (Object)this.existingFileHelper));
        }
    }

    public void addBlockStateProvider(Function3<DataGenerator, String, ExistingFileHelper, ? extends BlockStateProvider> blockStateProviderConstructor) {
        if (this.includeClient) {
            this.dataGenerator.func_200390_a((IDataProvider)blockStateProviderConstructor.apply((Object)this.dataGenerator, (Object)this.modId, (Object)this.existingFileHelper));
        }
    }

    public void addItemModelProvider(Function3<DataGenerator, String, ExistingFileHelper, ? extends ItemModelProvider> itemModelProviderConstructor) {
        if (this.includeClient) {
            this.dataGenerator.func_200390_a((IDataProvider)itemModelProviderConstructor.apply((Object)this.dataGenerator, (Object)this.modId, (Object)this.existingFileHelper));
        }
    }

    public void addLanguageProvider(BiFunction<DataGenerator, String, ? extends LanguageProvider> languageProviderConstructor) {
        if (this.includeClient) {
            this.dataGenerator.func_200390_a((IDataProvider)languageProviderConstructor.apply(this.dataGenerator, this.modId));
        }
    }
}

