/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.Arrays;
import net.minecraft.network.PacketBuffer;

public class PictureSendPacket {
    private String name;
    private int version;
    private int[] pixels;
    private boolean messageIsValid;

    public PictureSendPacket(String name, int version, int[] pixels) {
        this.name = name;
        this.version = version;
        this.pixels = Arrays.copyOfRange(pixels, 0, pixels.length);
    }

    public PictureSendPacket() {
        this.messageIsValid = false;
    }

    public static void encode(PictureSendPacket pkt, PacketBuffer buf) {
        buf.func_180714_a(pkt.name);
        buf.writeInt(pkt.version);
        buf.func_186875_a(pkt.pixels);
    }

    public static PictureSendPacket decode(PacketBuffer buf) {
        PictureSendPacket result = new PictureSendPacket();
        try {
            result.name = buf.func_150789_c(64);
            result.version = buf.readInt();
            result.pixels = buf.func_189424_c(1024);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading PictureSendPacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }
}

