/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.PaletteUpdatePacket;

public class PaletteUpdatePacketHandler {
    public static void handle(PaletteUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when PaletteUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> PaletteUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(PaletteUpdatePacket msg, ServerPlayerEntity pl) {
        ItemStack palette = pl.func_184614_ca();
        if (!palette.func_190926_b() && palette.func_77973_b() == Items.ITEM_PALETTE) {
            CompoundNBT paletteComp = palette.func_196082_o();
            PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
        }
    }
}

