/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item.crafting;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeFillPalette
extends SpecialRecipe {
    public RecipeFillPalette(ResourceLocation p_i48170_1_) {
        super(p_i48170_1_);
    }

    private boolean isPalette(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPalette;
    }

    private boolean isDye(ItemStack stack) {
        return stack.func_77973_b() instanceof DyeItem;
    }

    @Nullable
    private int findPalette(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!this.isPalette(stack)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<ItemStack> findDyes(CraftingInventory inv, int paletteId) {
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (i == paletteId) continue;
            ItemStack stack = inv.func_70301_a(i);
            if (this.isDye(stack)) {
                dyes.add(stack);
                continue;
            }
            if (stack.func_190926_b()) continue;
            return null;
        }
        return dyes;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return false;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, paletteId);
        return dyes != null && !dyes.isEmpty();
    }

    public ItemStack assemble(CraftingInventory inv) {
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return ItemStack.field_190927_a;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, paletteId);
        if (dyes == null || dyes.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack inputPalette = inv.func_70301_a(paletteId);
        CompoundNBT orgTag = inputPalette.func_196082_o().func_74737_b();
        byte[] basicColors = orgTag.func_74764_b("basic") ? orgTag.func_74770_j("basic") : new byte[16];
        for (ItemStack dye : dyes) {
            DyeColor color = ((DyeItem)dye.func_77973_b()).func_195962_g();
            int realColorId = 15 - color.func_196059_a();
            if (basicColors[realColorId] > 0) {
                return ItemStack.field_190927_a;
            }
            basicColors[realColorId] = 1;
        }
        orgTag.func_74773_a("basic", basicColors);
        ItemStack result = new ItemStack((IItemProvider)Items.ITEM_PALETTE);
        result.func_77982_d(orgTag);
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Items.CRAFTING_SPECIAL_PALETTE_FILLING;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }
}

