/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercapaint.client.ClientStuff;
import xerca.xercapaint.common.item.Items;

public class ItemPalette
extends Item {
    ItemPalette(String name) {
        super(new Item.Properties().func_200916_a((ItemGroup)Items.paintTab).func_200917_a(1));
        this.setRegistryName(name);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        if (worldIn.field_72995_K) {
            ClientStuff.showCanvasGui(playerIn);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack fullPalette = new ItemStack((IItemProvider)this);
            byte[] basicColors = new byte[16];
            Arrays.fill(basicColors, (byte)1);
            fullPalette.func_196082_o().func_74773_a("basic", basicColors);
            items.add((Object)fullPalette);
        }
    }

    public static boolean isFull(ItemStack stack) {
        return ItemPalette.basicColorCount(stack) == 16;
    }

    public static int basicColorCount(ItemStack stack) {
        byte[] basicColors;
        if (stack.func_77973_b() != Items.ITEM_PALETTE) {
            return 0;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("basic") && (basicColors = tag.func_74770_j("basic")).length == 16) {
            int basicCount = 0;
            for (byte basicColor : basicColors) {
                basicCount += basicColor;
            }
            return basicCount;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null) {
                int[] ns;
                byte[] basicColors = tag.func_74770_j("basic");
                if (basicColors.length == 16) {
                    int basicCount = 0;
                    for (byte basicColor : basicColors) {
                        basicCount += basicColor;
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("palette.basic_count", new Object[]{String.valueOf(basicCount)}).func_240699_a_(TextFormatting.GRAY));
                }
                if ((ns = tag.func_74759_k("n")).length == 12) {
                    int fullCount = 0;
                    for (int n : ns) {
                        if (n <= 0) continue;
                        ++fullCount;
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("palette.custom_count", new Object[]{String.valueOf(fullCount)}).func_240699_a_(TextFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("palette.empty").func_240699_a_(TextFormatting.GRAY));
        }
    }
}

