/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.ImportPaintingPacket;

public class CommandImport {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"paintimport").requires(p -> p.func_197034_c(1))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandImport.paintImport((CommandSource)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int paintImport(CommandSource stack, String name) {
        XercaPaint.LOGGER.debug("Paint import called. name: " + name);
        ImportPaintingPacket pack = new ImportPaintingPacket(name);
        try {
            ServerPlayerEntity player = stack.func_197035_h();
            XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)pack);
        }
        catch (CommandSyntaxException e) {
            XercaPaint.LOGGER.debug("Command executor is not a player");
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public static void doImport(CompoundNBT tag, ServerPlayerEntity player) {
        byte canvasType = tag.func_74771_c("ct");
        tag.func_82580_o("ct");
        if (tag.func_74762_e("generation") > 0) {
            tag.func_74768_a("generation", tag.func_74762_e("generation") + 1);
        }
        if (player.func_184812_l_()) {
            ItemStack itemStack;
            switch (CanvasType.fromByte(canvasType)) {
                case SMALL: {
                    itemStack = new ItemStack((IItemProvider)Items.ITEM_CANVAS);
                    break;
                }
                case LONG: {
                    itemStack = new ItemStack((IItemProvider)Items.ITEM_CANVAS_LONG);
                    break;
                }
                case TALL: {
                    itemStack = new ItemStack((IItemProvider)Items.ITEM_CANVAS_TALL);
                    break;
                }
                case LARGE: {
                    itemStack = new ItemStack((IItemProvider)Items.ITEM_CANVAS_LARGE);
                    break;
                }
                default: {
                    XercaPaint.LOGGER.error("Invalid canvas type");
                    return;
                }
            }
            itemStack.func_77982_d(tag);
            player.func_191521_c(itemStack);
        } else {
            ItemStack mainhand = player.func_184614_ca();
            ItemStack offhand = player.func_184592_cb();
            if (!(mainhand.func_77973_b() instanceof ItemCanvas) || mainhand.func_77942_o() && !mainhand.func_77978_p().isEmpty()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("import.fail.1").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                return;
            }
            if (((ItemCanvas)mainhand.func_77973_b()).getCanvasType() != CanvasType.fromByte(canvasType)) {
                ITextComponent type = Items.ITEM_CANVAS.func_200295_i(ItemStack.field_190927_a);
                switch (CanvasType.fromByte(canvasType)) {
                    case LONG: {
                        type = Items.ITEM_CANVAS_LONG.func_200295_i(ItemStack.field_190927_a);
                        break;
                    }
                    case TALL: {
                        type = Items.ITEM_CANVAS_TALL.func_200295_i(ItemStack.field_190927_a);
                        break;
                    }
                    case LARGE: {
                        type = Items.ITEM_CANVAS_LARGE.func_200295_i(ItemStack.field_190927_a);
                    }
                }
                player.func_145747_a((ITextComponent)new TranslationTextComponent("import.fail.2", new Object[]{type}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                return;
            }
            if (!ItemPalette.isFull(offhand)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("import.fail.3").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                return;
            }
            mainhand.func_77982_d(tag);
        }
        player.func_145747_a((ITextComponent)new TranslationTextComponent("import.success").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
    }
}

