/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraftforge.fml.network.PacketDistributor;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.packets.ExportPaintingPacket;

public class CommandExport {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"paintexport").requires(p -> p.func_197034_c(1))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandExport.paintExport((CommandSource)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int paintExport(CommandSource stack, String name) {
        XercaPaint.LOGGER.debug("Paint export called. name: " + name);
        if (stack.func_197022_f() == null) {
            XercaPaint.LOGGER.error("Command entity is not found");
            return 0;
        }
        Entity commander = stack.func_197022_f();
        if (!(commander instanceof ServerPlayerEntity)) {
            XercaPaint.LOGGER.error("Command entity is not a player");
            return 0;
        }
        ExportPaintingPacket pack = new ExportPaintingPacket(name);
        XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)commander), (Object)pack);
        return 1;
    }

    public static boolean doExport(PlayerEntity player, String name) {
        String dir = "paintings";
        String filename = name + ".paint";
        String filepath = dir + "/" + filename;
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        for (ItemStack s : player.func_184214_aD()) {
            if (!(s.func_77973_b() instanceof ItemCanvas) || !s.func_77942_o()) continue;
            try {
                CompoundNBT tag = s.func_77978_p().func_74737_b();
                tag.func_74774_a("ct", (byte)((ItemCanvas)s.func_77973_b()).getCanvasType().ordinal());
                CompressedStreamTools.func_74795_b((CompoundNBT)tag, (File)new File(filepath));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

