/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityCanvas;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class RenderEntityCanvas
extends EntityRenderer<EntityCanvas> {
    public static RenderEntityCanvas theInstance;
    private static final ResourceLocation backLocation;
    private static final int[] EMPTY_PIXELS;
    private final TextureManager textureManager;
    private final Map<String, Instance> loadedCanvases = Maps.newHashMap();

    RenderEntityCanvas(EntityRendererManager renderManager) {
        super(renderManager);
        this.textureManager = Minecraft.func_71410_x().field_71446_o;
    }

    @Nullable
    public ResourceLocation getTextureLocation(EntityCanvas entity) {
        return this.getCanvasRendererInstance((EntityCanvas)entity).location;
    }

    public void render(EntityCanvas entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        this.getCanvasRendererInstance(entity).render(entity, entityYaw, entity.field_70125_A, matrixStackIn, bufferIn, entity.func_174811_aO(), packedLightIn);
    }

    public void updateTexture(String name, int version) {
        Instance instance = this.getMapInstanceIfExists(name);
        if (instance != null) {
            instance.updateCanvasTexture(name, version);
        }
    }

    private Instance getCanvasRendererInstance(EntityCanvas canvas) {
        return this.getCanvasRendererInstance(canvas.getCanvasName(), canvas.getCanvasVersion(), canvas.func_82329_d(), canvas.func_82330_g());
    }

    Instance getCanvasRendererInstance(CompoundNBT tag, int width, int height) {
        String name = tag.func_74779_i("name");
        int version = tag.func_74762_e("v");
        if (!EntityCanvas.PICTURES.containsKey(name) || EntityCanvas.PICTURES.get((Object)name).version < version) {
            EntityCanvas.PICTURES.put(name, new EntityCanvas.Picture(version, tag.func_74759_k("pixels")));
        }
        return this.getCanvasRendererInstance(name, version, width, height);
    }

    Instance getCanvasRendererInstance(String name, int version, int width, int height) {
        Instance instance = this.loadedCanvases.get(name);
        if (instance == null) {
            instance = new Instance(name, version, width, height);
            this.loadedCanvases.put(name, instance);
        } else if (instance.version < version || !instance.loaded) {
            instance.updateCanvasTexture(name, version);
        }
        return instance;
    }

    @Nullable
    public Instance getMapInstanceIfExists(String name) {
        return this.loadedCanvases.get(name);
    }

    public void clearLoadedCanvases() {
        for (Instance instance : this.loadedCanvases.values()) {
            instance.close();
        }
        this.loadedCanvases.clear();
    }

    public void close() {
        this.clearLoadedCanvases();
    }

    static {
        backLocation = new ResourceLocation("minecraft", "textures/block/birch_planks.png");
        EMPTY_PIXELS = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            RenderEntityCanvas.EMPTY_PIXELS[i] = PaletteUtil.Color.WHITE.rgbVal();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Instance
    implements AutoCloseable {
        int version = 0;
        int width;
        int height;
        boolean loaded = false;
        boolean started = false;
        public final DynamicTexture canvasTexture;
        public final ResourceLocation location;

        private Instance(String name, int version, int width, int height) {
            this.width = width;
            this.height = height;
            this.canvasTexture = new DynamicTexture(width, height, true);
            this.location = RenderEntityCanvas.this.textureManager.func_110578_a("canvas/" + name, this.canvasTexture);
            this.updateCanvasTexture(name, version);
        }

        private int swapColor(int color) {
            int i = (color & 0xFF0000) >> 16;
            int j = (color & 0xFF00) >> 8;
            int k = color & 0xFF;
            return k << 16 | j << 8 | i;
        }

        private void updateCanvasTexture(String name, int version) {
            this.version = version;
            int[] pixels = EMPTY_PIXELS;
            if (EntityCanvas.PICTURES.containsKey(name)) {
                pixels = EntityCanvas.PICTURES.get((Object)name).pixels;
                this.loaded = true;
            }
            if (this.loaded || !this.started) {
                if (pixels.length < this.height * this.width) {
                    XercaPaint.LOGGER.warn("Pixels array length (" + pixels.length + ") is smaller than canvas area (" + this.height * this.width + ")");
                    return;
                }
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int k = j + i * this.width;
                        this.canvasTexture.func_195414_e().func_195700_a(j, i, this.swapColor(pixels[k]));
                    }
                }
                this.canvasTexture.func_110564_a();
            }
            this.started = true;
        }

        public void render(@Nullable EntityCanvas canvas, float yaw, float pitch, MatrixStack ms, IRenderTypeBuffer buffer, Direction facing, int packedLight) {
            float wScale = (float)this.width / 16.0f;
            float hScale = (float)this.height / 16.0f;
            ms.func_227860_a_();
            Matrix3f mn = ms.func_227866_c_().func_227872_b_().func_226121_d_();
            float xOffset = facing.func_82601_c();
            float yOffset = facing.func_96559_d();
            float zOffset = facing.func_82599_e();
            if (canvas != null && canvas.getRotation() > 0) {
                ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - yaw));
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(90 * canvas.getRotation())));
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-180.0f + yaw));
                ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-pitch));
            }
            ms.func_227866_c_().func_227872_b_().func_226114_a_(mn);
            float f = 0.03125f;
            if (canvas != null) {
                if (facing.func_176740_k().func_176722_c()) {
                    ms.func_227861_a_((double)zOffset * 0.5 * (double)wScale, -0.5 * (double)hScale, (double)(-xOffset) * 0.5 * (double)wScale);
                } else {
                    ms.func_227861_a_(0.5 * (double)wScale, (double)(0.0f * hScale), (yOffset > 0.0f ? 0.5 : -0.5) * (double)wScale);
                }
            } else {
                ms.func_227861_a_(0.75, 0.5, 0.5);
                f = wScale > 1.0f || hScale > 1.0f ? (f /= 3.3f) : (f /= 2.0f);
            }
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - yaw));
            ms.func_227862_a_(f, f, f);
            RenderEntityCanvas.this.textureManager.func_110577_a(this.location);
            Matrix4f m = ms.func_227866_c_().func_227870_a_();
            mn = ms.func_227866_c_().func_227872_b_();
            IVertexBuilder vb = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.location));
            this.addVertex(vb, m, mn, 0.0, 32.0f * hScale, -1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0f * wScale, 32.0f * hScale, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0f * wScale, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            vb = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)backLocation));
            float sideWidth = 0.0625f;
            RenderEntityCanvas.this.textureManager.func_110577_a(backLocation);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 1.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
            ms.func_227865_b_();
        }

        private void addVertex(IVertexBuilder vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
            vb.func_227888_a_(m, (float)x, (float)y, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(tx, ty).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(mn, xOff, yOff, zOff).func_181675_d();
        }

        private void addVertexFront(IVertexBuilder vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
            vb.func_227888_a_(m, (float)x, (float)y, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(tx, ty).func_227886_a_(lightmap).func_181675_d();
        }

        @Override
        public void close() {
            this.canvasTexture.close();
        }
    }

    public static class RenderEntityCanvasFactory
    implements IRenderFactory<EntityCanvas> {
        public EntityRenderer<? super EntityCanvas> createRenderFor(EntityRendererManager manager) {
            theInstance = new RenderEntityCanvas(manager);
            return theInstance;
        }
    }
}

