/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;
import xerca.xercapaint.client.BasePalette;
import xerca.xercapaint.client.BrushSound;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.SoundEvents;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.packets.CanvasMiniUpdatePacket;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;
import xerca.xercapaint.common.packets.EaselLeftPacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiCanvasEdit
extends BasePalette {
    private double canvasX;
    private double canvasY;
    private static final double[] canvasXs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0};
    private static final double[] canvasYs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0};
    private final int canvasWidth;
    private final int canvasHeight;
    private int brushMeterX;
    private int brushMeterY;
    private int brushOpacityMeterX;
    private int brushOpacityMeterY;
    private final int canvasPixelScale;
    private final int canvasPixelWidth;
    private final int canvasPixelHeight;
    private int brushSize = 0;
    private boolean touchedCanvas = false;
    private boolean undoStarted = false;
    private boolean gettingSigned;
    private boolean isCarryingCanvas;
    private Button buttonSign;
    private Button buttonCancel;
    private Button buttonFinalize;
    private Button buttonHelpToggle;
    private int updateCount = 0;
    private BrushSound brushSound = null;
    private final int canvasHolderHeight = 10;
    private static int brushOpacitySetting = 0;
    private static final float[] brushOpacities = new float[]{1.0f, 0.75f, 0.5f, 0.25f};
    private static boolean showHelp = false;
    private final Set<Integer> draggedPoints = new HashSet<Integer>();
    private final PlayerEntity editingPlayer;
    private final CanvasType canvasType;
    private boolean isSigned = false;
    private int[] pixels;
    private String authorName = "";
    private String canvasTitle = "";
    private String name = "";
    private int version = 0;
    private final EntityEasel easel;
    private int timeSinceLastUpdate = 0;
    private boolean skippedUpdate = false;
    private static final Vector2f[] outlinePoss1 = new Vector2f[]{new Vector2f(0.0f, 199.0f), new Vector2f(12.0f, 199.0f), new Vector2f(34.0f, 199.0f), new Vector2f(76.0f, 199.0f)};
    private static final Vector2f[] outlinePoss2 = new Vector2f[]{new Vector2f(128.0f, 199.0f), new Vector2f(135.0f, 199.0f), new Vector2f(147.0f, 199.0f), new Vector2f(169.0f, 199.0f)};
    private static final int maxUndoLength = 16;
    private Deque<int[]> undoStack = new ArrayDeque<int[]>(16);

    protected GuiCanvasEdit(PlayerEntity player, CompoundNBT canvasTag, CompoundNBT paletteTag, ITextComponent title, CanvasType canvasType, EntityEasel easel) {
        super(title, paletteTag);
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.canvasHeight = this.canvasPixelHeight * this.canvasPixelScale;
        this.easel = easel;
        this.editingPlayer = player;
        if (canvasTag != null && !canvasTag.isEmpty()) {
            int[] nbtPixels = canvasTag.func_74759_k("pixels");
            this.authorName = canvasTag.func_74779_i("author");
            this.canvasTitle = canvasTag.func_74779_i("title");
            this.name = canvasTag.func_74779_i("name");
            this.version = canvasTag.func_74762_e("v");
            this.pixels = Arrays.copyOfRange(nbtPixels, 0, canvasPixelArea);
        } else {
            this.isSigned = false;
        }
        if (this.pixels == null) {
            this.pixels = new int[canvasPixelArea];
            Arrays.fill(this.pixels, basicColors[15].rgbVal());
            long secs = System.currentTimeMillis() / 1000L;
            this.name = "" + player.func_110124_au() + "_" + secs;
        }
        if (this.paletteComplete) {
            XercaPaint.LOGGER.warn("Is complete");
        }
    }

    public void func_231160_c_() {
        this.canvasX = canvasXs[this.canvasType.ordinal()];
        this.canvasY = canvasYs[this.canvasType.ordinal()];
        this.paletteX = paletteXs[this.canvasType.ordinal()];
        this.paletteY = paletteYs[this.canvasType.ordinal()];
        if (this.canvasX == -1000.0 || this.canvasY == -1000.0 || this.paletteX == -1000.0 || this.paletteY == -1000.0) {
            this.resetPositions();
        }
        this.updateCanvasPos(0.0, 0.0);
        this.updatePalettePos(0.0, 0.0);
        GLFW.glfwSetInputMode((long)this.getMinecraft().func_228018_at_().func_198092_i(), (int)208897, (int)212994);
        int x = this.getMinecraft().func_228018_at_().func_198107_o() - 120;
        int y = this.getMinecraft().func_228018_at_().func_198087_p() - 30;
        this.buttonSign = (Button)this.func_230480_a_((Widget)new Button(x, y, 98, 20, (ITextComponent)new TranslationTextComponent("canvas.signButton"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = true;
                this.resetPositions();
                this.updateButtons();
                GLFW.glfwSetInputMode((long)this.getMinecraft().func_228018_at_().func_198092_i(), (int)208897, (int)212993);
            }
        }));
        this.buttonFinalize = (Button)this.func_230480_a_((Widget)new Button((int)this.canvasX - 100, 100, 98, 20, (ITextComponent)new TranslationTextComponent("canvas.finalizeButton"), button -> {
            if (!this.isSigned) {
                this.dirty = true;
                this.isSigned = true;
                if (this.field_230706_i_ != null) {
                    this.field_230706_i_.func_147108_a(null);
                }
            }
        }));
        this.buttonCancel = (Button)this.func_230480_a_((Widget)new Button((int)this.canvasX - 100, 130, 98, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = false;
                this.updateButtons();
                GLFW.glfwSetInputMode((long)this.getMinecraft().func_228018_at_().func_198092_i(), (int)208897, (int)212994);
            }
        }));
        x = (int)((double)this.getMinecraft().func_228018_at_().func_198107_o() * 0.95) - 21;
        y = (int)((double)this.getMinecraft().func_228018_at_().func_198087_p() * 0.05);
        this.buttonHelpToggle = (Button)this.func_230480_a_((Widget)new ToggleHelpButton(x, y, 21, 21, 197, 0, 21, paletteTextures, 256, 256, button -> {
            showHelp = !showHelp;
        }, (button, poseStack, i, j) -> this.func_238652_a_(poseStack, (ITextComponent)new StringTextComponent("Toggle help tooltips"), i, j)));
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.isSigned) {
            this.buttonSign.field_230694_p_ = !this.gettingSigned;
            this.buttonCancel.field_230694_p_ = this.gettingSigned;
            this.buttonFinalize.field_230694_p_ = this.gettingSigned;
            this.buttonFinalize.field_230693_o_ = !this.canvasTitle.trim().isEmpty();
            this.buttonFinalize.field_230690_l_ = (int)this.canvasX - 100;
            this.buttonCancel.field_230690_l_ = (int)this.canvasX - 100;
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels[y * this.canvasPixelWidth + x];
    }

    private void setPixelAt(int x, int y, PaletteUtil.Color color, float opacity) {
        if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight && !this.draggedPoints.contains(y * this.canvasPixelWidth + x)) {
            this.draggedPoints.add(y * this.canvasPixelWidth + x);
            this.pixels[y * this.canvasPixelWidth + x] = PaletteUtil.Color.mix(color, new PaletteUtil.Color(this.pixels[y * this.canvasPixelWidth + x]), opacity).rgbVal();
        }
    }

    private void setPixelsAt(int mouseX, int mouseY, PaletteUtil.Color color, int brushSize, float opacity) {
        int pixelHalf = this.canvasPixelScale / 2;
        switch (brushSize) {
            case 0: {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x, y, color, opacity);
                break;
            }
            case 1: {
                int x = (mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                break;
            }
            case 2: {
                int x = (mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 1, color, opacity);
                this.setPixelAt(x, y + 1, color, opacity);
                this.setPixelAt(x - 2, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x, y, color, opacity);
                this.setPixelAt(x + 1, y, color, opacity);
                this.setPixelAt(x - 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                this.setPixelAt(x, y - 1, color, opacity);
                this.setPixelAt(x + 1, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 2, color, opacity);
                this.setPixelAt(x, y - 2, color, opacity);
                break;
            }
            case 3: {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 2, color, opacity);
                this.setPixelAt(x + 0, y + 2, color, opacity);
                this.setPixelAt(x + 1, y + 2, color, opacity);
                this.setPixelAt(x - 2, y + 1, color, opacity);
                this.setPixelAt(x - 1, y + 1, color, opacity);
                this.setPixelAt(x + 0, y + 1, color, opacity);
                this.setPixelAt(x + 1, y + 1, color, opacity);
                this.setPixelAt(x + 2, y + 1, color, opacity);
                this.setPixelAt(x - 2, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x + 0, y, color, opacity);
                this.setPixelAt(x + 1, y, color, opacity);
                this.setPixelAt(x + 2, y, color, opacity);
                this.setPixelAt(x - 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                this.setPixelAt(x + 0, y - 1, color, opacity);
                this.setPixelAt(x + 1, y - 1, color, opacity);
                this.setPixelAt(x + 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 2, color, opacity);
                this.setPixelAt(x + 0, y - 2, color, opacity);
                this.setPixelAt(x + 1, y - 2, color, opacity);
            }
        }
    }

    private void resetPositions() {
        int padding = 40;
        int paletteCanvasX = (this.field_230708_k_ - (157 + this.canvasWidth + 40)) / 2;
        this.canvasX = paletteCanvasX + 157 + 40;
        this.canvasY = this.canvasType.equals((Object)CanvasType.LONG) ? 80.0 : 40.0;
        this.paletteX = paletteCanvasX;
        this.paletteY = 40.0;
    }

    public void func_231023_e_() {
        ++this.updateCount;
        ++this.timeSinceLastUpdate;
        if (this.easel != null) {
            if (this.easel.getItem().func_190926_b() || !this.easel.func_70089_S() || this.easel.func_70068_e((Entity)this.editingPlayer) > 64.0) {
                this.func_231175_as__();
            }
            if (this.skippedUpdate && this.timeSinceLastUpdate > 20 && this.dirty) {
                this.updateCanvas(false);
                this.skippedUpdate = false;
            }
        }
        super.func_231023_e_();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float f) {
        int i;
        if (!this.gettingSigned) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, f);
        } else {
            super.superRender(matrixStack, mouseX, mouseY, f);
        }
        GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)((int)(this.canvasX + (double)this.canvasWidth * 0.25)), (int)((int)this.canvasY - 10), (int)((int)(this.canvasX + (double)this.canvasWidth * 0.75)), (int)((int)this.canvasY), (int)-1973791);
        for (i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int y = (int)this.canvasY + i * this.canvasPixelScale;
                int x = (int)this.canvasX + j * this.canvasPixelScale;
                GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + this.canvasPixelScale), (int)(y + this.canvasPixelScale), (int)this.getPixelAt(j, i));
            }
        }
        if (!this.gettingSigned) {
            for (i = 0; i < 4; ++i) {
                int y = this.brushMeterY + i * 9;
                GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)this.brushMeterX, (int)y, (int)(this.brushMeterX + 3), (int)(y + 3), (int)currentColor.rgbVal());
            }
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(matrixStack, this.brushMeterX, this.brushMeterY + (3 - this.brushSize) * 9, 15, 246, 10, 10);
            this.func_238474_b_(matrixStack, this.brushMeterX, this.brushMeterY, 0, 220, 9, 36);
            this.func_238474_b_(matrixStack, this.brushOpacityMeterX, this.brushOpacityMeterY, 196, 197, 14, 59);
            this.func_238474_b_(matrixStack, this.brushOpacityMeterX - 1, this.brushOpacityMeterY - 1 + brushOpacitySetting * 15, 212, 240, 16, 16);
            this.renderCursor(matrixStack, mouseX, mouseY);
            if (showHelp) {
                if (this.inBrushMeter(mouseX, mouseY)) {
                    int selectedSize = 3 - (mouseY - this.brushMeterY) / 9;
                    if (selectedSize <= 3 && selectedSize >= 0) {
                        this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("canvas.brushSize", new Object[]{selectedSize + 1}), mouseX, mouseY);
                    }
                } else if (this.inBrushOpacityMeter(mouseX, mouseY)) {
                    int relativeY = mouseY - this.brushOpacityMeterY;
                    int selectedOpacity = relativeY / 15;
                    if (selectedOpacity >= 0 && selectedOpacity <= 3) {
                        int percentage = 100 - 25 * selectedOpacity;
                        this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("canvas.brushOpacity", new Object[]{percentage}), mouseX, mouseY);
                    }
                } else if (this.inColorPicker(mouseX - (int)this.paletteX, mouseY - (int)this.paletteY)) {
                    this.func_243308_b(matrixStack, Arrays.asList(new TranslationTextComponent("canvas.colorPicker.title"), new TranslationTextComponent("canvas.colorPicker.desc").func_240699_a_(TextFormatting.GRAY)), mouseX, mouseY);
                } else if (this.inWater(mouseX - (int)this.paletteX, mouseY - (int)this.paletteY)) {
                    this.func_243308_b(matrixStack, Arrays.asList(new TranslationTextComponent("canvas.colorCleaner.title"), new TranslationTextComponent("canvas.colorCleaner.desc").func_240699_a_(TextFormatting.GRAY)), mouseX, mouseY);
                } else if (this.inCanvasHolder(mouseX, mouseY)) {
                    this.func_243308_b(matrixStack, Arrays.asList(new TranslationTextComponent("canvas.canvasHolder.title"), new TranslationTextComponent("canvas.canvasHolder.desc").func_240699_a_(TextFormatting.GRAY)), mouseX, mouseY);
                }
            }
        } else {
            this.drawSigning(matrixStack);
        }
    }

    private void renderCursor(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isCarryingColor) {
            this.carriedColor.setGLColor();
            this.func_238474_b_(matrixStack, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isCarryingWater) {
            waterColor.setGLColor();
            this.func_238474_b_(matrixStack, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isPickingColor) {
            this.drawOutline(matrixStack, mouseX, mouseY, 0);
            PaletteUtil.Color.WHITE.setGLColor();
            this.func_238474_b_(matrixStack, mouseX, mouseY - 14, 25, 242, 14, 14);
        } else {
            this.drawOutline(matrixStack, mouseX, mouseY, this.brushSize);
            GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)mouseX, (int)mouseY, (int)(mouseX + 3), (int)(mouseY + 3), (int)currentColor.rgbVal());
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int trueBrushY = 247 - 9 * this.brushSize;
            this.func_238474_b_(matrixStack, mouseX, mouseY, 0, trueBrushY, 9, 9);
        }
    }

    private void drawOutline(MatrixStack matrixStack, int mouseX, int mouseY, int brushSize) {
        if (this.inCanvas(mouseX, mouseY)) {
            int x = 0;
            int y = 0;
            int outlineSize = 0;
            int pixelHalf = this.canvasPixelScale / 2;
            if (brushSize == 0) {
                x = (mouseX - (int)this.canvasX) / this.canvasPixelScale * this.canvasPixelScale + (int)this.canvasX - 1;
                y = (mouseY - (int)this.canvasY) / this.canvasPixelScale * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale + 2;
            }
            if (brushSize == 1) {
                x = ((mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 2 + 2;
            }
            if (brushSize == 2) {
                x = ((mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 4 + 2;
            }
            if (brushSize == 3) {
                x = ((mouseX - (int)this.canvasX) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 5 + 2;
            }
            Vector2f textureVec = this.canvasPixelScale == 10 ? outlinePoss1[brushSize] : outlinePoss2[brushSize];
            GlStateManager.func_227702_d_((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            this.func_238474_b_(matrixStack, x, y, (int)textureVec.field_189982_i, (int)textureVec.field_189983_j, outlineSize, outlineSize);
        }
    }

    private void drawSigning(MatrixStack matrixStack) {
        int i = (int)this.canvasX;
        int j = (int)this.canvasY;
        GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)(i + 10), (int)(j + 10), (int)(i + 150), (int)(j + 150), (int)-1118482);
        String s = this.canvasTitle;
        if (!this.isSigned) {
            s = this.updateCount / 6 % 2 == 0 ? s + "" + TextFormatting.BLACK + "_" : s + "" + TextFormatting.GRAY + "_";
        }
        String s1 = I18n.func_135052_a((String)"canvas.editTitle", (Object[])new Object[0]);
        int k = this.field_230712_o_.func_78256_a(s1);
        this.field_230712_o_.func_238421_b_(matrixStack, s1, (float)(i + 26) + (float)(116 - k) / 2.0f, (float)(j + 16 + 16), 0);
        int l = this.field_230712_o_.func_78256_a(s);
        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(i + 26) + (float)(116 - l) / 2.0f, (float)(j + 48), 0);
        String s2 = I18n.func_135052_a((String)"canvas.byAuthor", (Object[])new Object[]{this.editingPlayer.func_200200_C_().getString()});
        int i1 = this.field_230712_o_.func_78256_a(s2);
        this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + s2, (float)(i + 26 + (116 - i1) / 2), (float)(j + 48 + 10), 0);
        this.field_230712_o_.func_238418_a_((ITextProperties)new TranslationTextComponent("canvas.finalizeWarning"), i + 26, j + 80, 116, 0);
    }

    private void playBrushSound() {
        this.brushSound = new BrushSound();
        this.playSound((ISound)this.brushSound);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.gettingSigned) {
            switch (keyCode) {
                case 259: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.canvasTitle = this.canvasTitle.substring(0, this.canvasTitle.length() - 1);
                    this.updateButtons();
                    break;
                }
                case 257: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.dirty = true;
                    this.isSigned = true;
                    this.field_230706_i_.func_147108_a(null);
                    break;
                }
            }
            return true;
        }
        if (keyCode == 90 && (modifiers & 2) == 2) {
            if (this.undoStack.size() > 0) {
                this.pixels = this.undoStack.pop();
                if (this.easel != null) {
                    this.updateCanvas(false);
                }
            }
            return true;
        }
        if (keyCode == 79 && ++brushOpacitySetting >= 4) {
            brushOpacitySetting = 0;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char typedChar, int something) {
        super.func_231042_a_(typedChar, something);
        if (!this.isSigned) {
            if (this.gettingSigned && this.canvasTitle.length() < 16 && SharedConstants.func_71566_a((char)typedChar)) {
                this.canvasTitle = this.canvasTitle + typedChar;
                this.updateButtons();
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double posX, double posY, double scroll) {
        int mouseX = (int)Math.floor(posX);
        int mouseY = (int)Math.floor(posY);
        if (!this.gettingSigned && scroll != 0.0) {
            if (this.inBrushOpacityMeter(mouseX, mouseY)) {
                int maxBrushOpacity = 3;
                if ((brushOpacitySetting += scroll < 0.0 ? 1 : -1) > 3) {
                    brushOpacitySetting = 0;
                } else if (brushOpacitySetting < 0) {
                    brushOpacitySetting = 3;
                }
                return true;
            }
            int maxBrushSize = 3;
            this.brushSize += scroll > 0.0 ? 1 : -1;
            if (this.brushSize > 3) {
                this.brushSize = 0;
            } else if (this.brushSize < 0) {
                this.brushSize = 3;
            }
            return true;
        }
        return super.func_231043_a_(posX, posY, scroll);
    }

    @Override
    public boolean func_231044_a_(double posX, double posY, int mouseButton) {
        if (this.gettingSigned) {
            return super.superMouseClicked(posX, posY, mouseButton);
        }
        int mouseX = (int)Math.floor(posX);
        int mouseY = (int)Math.floor(posY);
        this.undoStarted = true;
        this.touchedCanvas = false;
        if (this.undoStack.size() >= 16) {
            this.undoStack.removeLast();
        }
        this.undoStack.push((int[])this.pixels.clone());
        if (this.inCanvas(mouseX, mouseY)) {
            if (this.isPickingColor) {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight) {
                    int color = this.getPixelAt(x, y);
                    this.carriedColor = new PaletteUtil.Color(color);
                    this.setCarryingColor();
                    this.playSound(SoundEvents.COLOR_PICKER_SUCK);
                }
            } else {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
                this.playBrushSound();
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inBrushMeter(mouseX, mouseY)) {
            int selectedSize = 3 - (mouseY - this.brushMeterY) / 9;
            if (selectedSize <= 3 && selectedSize >= 0) {
                this.brushSize = selectedSize;
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inBrushOpacityMeter(mouseX, mouseY)) {
            int relativeY = mouseY - this.brushOpacityMeterY;
            int selectedOpacity = relativeY / 15;
            if (selectedOpacity >= 0 && selectedOpacity <= 3) {
                brushOpacitySetting = selectedOpacity;
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inCanvasHolder(mouseX, mouseY)) {
            this.isCarryingCanvas = true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private void clickedCanvas(int mouseX, int mouseY, int mouseButton) {
        this.touchedCanvas = true;
        if (mouseButton == 0) {
            this.setPixelsAt(mouseX, mouseY, currentColor, this.brushSize, brushOpacities[brushOpacitySetting]);
        } else if (mouseButton == 1) {
            this.setPixelsAt(mouseX, mouseY, PaletteUtil.Color.WHITE, this.brushSize, 1.0f);
        }
        this.dirty = true;
    }

    @Override
    public boolean func_231048_c_(double posX, double posY, int mouseButton) {
        this.isCarryingCanvas = false;
        if (this.gettingSigned) {
            return super.superMouseReleased(posX, posY, mouseButton);
        }
        this.draggedPoints.clear();
        if (this.undoStarted && !this.touchedCanvas) {
            this.undoStarted = false;
            this.undoStack.removeFirst();
        }
        if (this.brushSound != null) {
            this.brushSound.stopSound();
        }
        if (this.easel != null) {
            this.updateCanvas(false);
        }
        return super.func_231048_c_(posX, posY, mouseButton);
    }

    @Override
    public boolean func_231045_a_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        if (this.gettingSigned) {
            return super.superMouseDragged(posX, posY, mouseButton, deltaX, deltaY);
        }
        if (!(this.isCarryingColor || this.isCarryingWater || this.isPickingColor || this.isCarryingPalette || this.isCarryingCanvas)) {
            int mouseY;
            int mouseX = (int)Math.floor(posX);
            if (this.inCanvas(mouseX, mouseY = (int)Math.floor(posY))) {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
            }
            if (this.brushSound != null) {
                this.brushSound.refreshFade();
            }
        } else {
            if (this.isCarryingCanvas) {
                this.updateCanvasPos(deltaX, deltaY);
                return super.superMouseDragged(posX, posY, mouseButton, deltaX, deltaY);
            }
            if (this.isCarryingPalette) {
                boolean ret = super.func_231045_a_(posX, posY, mouseButton, deltaX, deltaY);
                this.updatePalettePos(deltaX, deltaY);
                return ret;
            }
        }
        return super.func_231045_a_(posX, posY, mouseButton, deltaX, deltaY);
    }

    private void updateCanvasPos(double deltaX, double deltaY) {
        this.canvasX += deltaX;
        this.canvasY += deltaY;
        this.brushMeterX = (int)this.canvasX + this.canvasWidth + 2;
        this.brushMeterY = (int)this.canvasY + this.canvasHeight / 2 + 30;
        this.brushOpacityMeterX = (int)this.canvasX + this.canvasWidth + 2;
        this.brushOpacityMeterY = (int)this.canvasY;
        GuiCanvasEdit.canvasXs[this.canvasType.ordinal()] = this.canvasX;
        GuiCanvasEdit.canvasYs[this.canvasType.ordinal()] = this.canvasY;
    }

    private void updatePalettePos(double deltaX, double deltaY) {
        this.paletteX += deltaX;
        this.paletteY += deltaY;
        GuiCanvasEdit.paletteXs[this.canvasType.ordinal()] = this.paletteX;
        GuiCanvasEdit.paletteYs[this.canvasType.ordinal()] = this.paletteY;
    }

    private boolean inCanvas(int x, int y) {
        return (double)x < this.canvasX + (double)this.canvasWidth && (double)x >= this.canvasX && (double)y < this.canvasY + (double)this.canvasHeight && (double)y >= this.canvasY;
    }

    private boolean inCanvasHolder(int x, int y) {
        return (double)x < this.canvasX + (double)this.canvasWidth * 0.75 && (double)x >= this.canvasX + (double)this.canvasWidth * 0.25 && (double)y < this.canvasY && (double)y >= this.canvasY - 10.0;
    }

    private boolean inBrushMeter(int x, int y) {
        return x < this.brushMeterX + 9 && x >= this.brushMeterX && y < this.brushMeterY + 36 && y >= this.brushMeterY;
    }

    private boolean inBrushOpacityMeter(int x, int y) {
        return x < this.brushOpacityMeterX + 14 && x >= this.brushOpacityMeterX && y < this.brushOpacityMeterY + 56 + 3 && y >= this.brushOpacityMeterY;
    }

    public void func_231164_f_() {
        this.updateCanvas(true);
    }

    private void updateCanvas(boolean closing) {
        if (closing) {
            if (this.dirty) {
                ++this.version;
                CanvasUpdatePacket pack = new CanvasUpdatePacket(this.pixels, this.isSigned, this.canvasTitle, this.name, this.version, this.easel, this.customColors, this.canvasType);
                XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
            } else if (this.easel != null) {
                EaselLeftPacket pack = new EaselLeftPacket(this.easel);
                XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
            }
        } else if (this.dirty) {
            if (this.timeSinceLastUpdate < 10) {
                this.skippedUpdate = true;
            } else {
                ++this.version;
                CanvasMiniUpdatePacket pack = new CanvasMiniUpdatePacket(this.pixels, this.name, this.version, this.easel, this.canvasType);
                XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
                this.dirty = false;
                this.timeSinceLastUpdate = 0;
            }
        }
    }

    public class ToggleHelpButton
    extends Button {
        protected final ResourceLocation resourceLocation;
        protected int xTexStart;
        protected int yTexStart;
        protected final int yDiffText;
        protected final int texWidth;
        protected final int texHeight;

        public ToggleHelpButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.IPressable onClick, Button.ITooltip onTooltip) {
            super(x, y, width, height, StringTextComponent.field_240750_d_, onClick, onTooltip);
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.xTexStart = xTexStart;
            this.yTexStart = yTexStart;
            this.yDiffText = yDiffText;
            this.resourceLocation = texture;
        }

        public void setTexStarts(int x, int y) {
            this.xTexStart = x;
            this.yTexStart = y;
        }

        protected void postRender() {
            GlStateManager.func_227734_k_();
        }

        public void func_230431_b_(MatrixStack matrixStack, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resourceLocation);
            GlStateManager.func_227731_j_();
            int yTexStartNew = this.yTexStart;
            if (this.func_230449_g_()) {
                yTexStartNew += this.yDiffText;
            }
            int xTexStartNew = this.xTexStart + (showHelp ? 0 : this.field_230688_j_);
            ToggleHelpButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)xTexStartNew, (float)yTexStartNew, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.texWidth, (int)this.texHeight);
            if (this.func_230449_g_()) {
                this.func_230443_a_(matrixStack, p_230431_2_, p_230431_3_);
            }
            this.postRender();
        }
    }
}

