/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.SoundEvents;

public abstract class BasePalette
extends Screen {
    protected static final ResourceLocation paletteTextures = new ResourceLocation("xercapaint", "textures/gui/palette.png");
    static final int dyeSpriteX = 240;
    static final int dyeSpriteSize = 16;
    static final int brushSpriteX = 0;
    static final int brushSpriteY = 247;
    static final int brushSpriteSize = 9;
    static final int brushOpacitySpriteX = 196;
    static final int brushOpacitySpriteY = 197;
    static final int brushOpacitySpriteSize = 14;
    static final int dropSpriteWidth = 6;
    static final int paletteWidth = 157;
    static final int paletteHeight = 193;
    static final int colorPickerSpriteX = 25;
    static final int colorPickerSpriteY = 242;
    static final int colorPickerPosX = 98;
    static final int colorPickerPosY = 62;
    static final int colorPickerSize = 14;
    static final double[] paletteXs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0, -1000.0};
    static final double[] paletteYs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0, -1000.0};
    double paletteX;
    double paletteY;
    static final PaletteUtil.Color waterColor = new PaletteUtil.Color(53, 118, 191);
    static final PaletteUtil.Color[] basicColors = new PaletteUtil.Color[]{new PaletteUtil.Color(-14869215), new PaletteUtil.Color(-5231066), new PaletteUtil.Color(-10585066), new PaletteUtil.Color(-8170446), new PaletteUtil.Color(-12827478), new PaletteUtil.Color(-7785800), new PaletteUtil.Color(-15295332), new PaletteUtil.Color(-6447721), new PaletteUtil.Color(-12103854), new PaletteUtil.Color(-816214), new PaletteUtil.Color(-8337633), new PaletteUtil.Color(-75715), new PaletteUtil.Color(-12930086), new PaletteUtil.Color(-3715395), new PaletteUtil.Color(-425955), new PaletteUtil.Color(-393218)};
    static final Vector2f[] basicColorCenters = new Vector2f[]{new Vector2f(23.5f, 172.5f), new Vector2f(18.5f, 145.5f), new Vector2f(16.5f, 117.5f), new Vector2f(17.5f, 89.5f), new Vector2f(23.5f, 62.5f), new Vector2f(38.5f, 39.5f), new Vector2f(61.5f, 24.5f), new Vector2f(87.5f, 17.5f), new Vector2f(114.5f, 15.5f), new Vector2f(44.5f, 154.5f), new Vector2f(41.5f, 127.5f), new Vector2f(42.5f, 100.5f), new Vector2f(48.5f, 74.5f), new Vector2f(64.5f, 52.5f), new Vector2f(90.5f, 44.5f), new Vector2f(117.5f, 42.5f)};
    static final Vector2f[] customColorCenters = new Vector2f[]{new Vector2f(101.5f, 132.0f), new Vector2f(113.5f, 118.0f), new Vector2f(120.5f, 102.0f), new Vector2f(124.5f, 84.0f), new Vector2f(126.5f, 66.0f), new Vector2f(97.5f, 152.0f), new Vector2f(114.5f, 146.0f), new Vector2f(127.5f, 133.0f), new Vector2f(134.5f, 116.0f), new Vector2f(139.5f, 98.0f), new Vector2f(142.5f, 80.0f), new Vector2f(144.5f, 62.0f)};
    static final Vector2f waterCenter = new Vector2f(140.5f, 28.0f);
    static final float basicColorRadius = 11.0f;
    static final float customColorRadius = 6.5f;
    boolean isPickingColor;
    boolean isCarryingColor;
    boolean isCarryingWater;
    boolean dirty;
    PaletteUtil.Color carriedColor;
    int carriedCustomColorId;
    static PaletteUtil.Color currentColor = basicColors[0];
    PaletteUtil.CustomColor[] customColors;
    boolean[] basicColorFlags;
    boolean paletteComplete;
    boolean isCarryingPalette;

    BasePalette(ITextComponent titleIn, CompoundNBT paletteTag) {
        block6: {
            block5: {
                super(titleIn);
                this.isPickingColor = false;
                this.isCarryingColor = false;
                this.isCarryingWater = false;
                this.dirty = false;
                this.carriedCustomColorId = -1;
                this.paletteComplete = false;
                this.isCarryingPalette = false;
                this.customColors = new PaletteUtil.CustomColor[12];
                this.basicColorFlags = new boolean[16];
                if (paletteTag == null || paletteTag.isEmpty()) break block5;
                if (paletteTag.func_74764_b("r") && paletteTag.func_74764_b("g") && paletteTag.func_74764_b("b") && paletteTag.func_74764_b("m") && paletteTag.func_74764_b("n")) {
                    PaletteUtil.readCustomColorArrayFromNBT(paletteTag, this.customColors);
                } else {
                    for (int i = 0; i < this.customColors.length; ++i) {
                        this.customColors[i] = new PaletteUtil.CustomColor();
                    }
                }
                if (!paletteTag.func_74764_b("basic")) break block6;
                this.paletteComplete = true;
                byte[] basics = paletteTag.func_74770_j("basic");
                for (int i = 0; i < basics.length; ++i) {
                    this.basicColorFlags[i] = basics[i] > 0;
                    this.paletteComplete &= this.basicColorFlags[i];
                }
                break block6;
            }
            for (int i = 0; i < this.customColors.length; ++i) {
                this.customColors[i] = new PaletteUtil.CustomColor();
            }
        }
    }

    protected void superRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int y;
        int x;
        int i;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(paletteTextures);
        for (i = 0; i < this.basicColorFlags.length; ++i) {
            x = (int)this.paletteX + (int)BasePalette.basicColorCenters[i].field_189982_i;
            y = (int)this.paletteY + (int)BasePalette.basicColorCenters[i].field_189983_j;
            int r = 11;
            if (this.basicColorFlags[i]) {
                BasePalette.func_238467_a_((MatrixStack)matrixStack, (int)(x - r), (int)(y - r), (int)(x + r + 1), (int)(y + r + 1), (int)basicColors[i].rgbVal());
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_238474_b_(matrixStack, x - 8, y - 8, 240, i * 16, 16, 16);
                continue;
            }
            BasePalette.func_238467_a_((MatrixStack)matrixStack, (int)(x - r), (int)(y - r), (int)(x + r + 1), (int)(y + r + 1), (int)PaletteUtil.emptinessColor.rgbVal());
        }
        for (i = 0; i < this.customColors.length; ++i) {
            x = (int)this.paletteX + (int)BasePalette.customColorCenters[i].field_189982_i;
            y = (int)this.paletteY + (int)BasePalette.customColorCenters[i].field_189983_j;
            BasePalette.func_238467_a_((MatrixStack)matrixStack, (int)(x - 6), (int)(y - 7), (int)(x + 7), (int)(y + 6), (int)this.customColors[i].getColor().rgbVal());
        }
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(matrixStack, (int)this.paletteX, (int)this.paletteY, 0, 0, 157, 193);
        if (this.paletteComplete) {
            this.func_238474_b_(matrixStack, (int)this.paletteX + 98, (int)this.paletteY + 62, 25, 242, 14, 14);
        }
    }

    protected boolean superMouseClicked(double posX, double posY, int mouseButton) {
        return super.func_231044_a_(posX, posY, mouseButton);
    }

    protected boolean superMouseReleased(double posX, double posY, int mouseButton) {
        return super.func_231048_c_(posX, posY, mouseButton);
    }

    protected boolean superMouseDragged(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        return super.func_231045_a_(posX, posY, mouseButton, deltaX, deltaY);
    }

    public boolean func_231044_a_(double posX, double posY, int mouseButton) {
        int mouseY;
        int mouseX = (int)Math.round(posX);
        if (this.paletteClick(mouseX, mouseY = (int)Math.round(posY))) {
            int i;
            int x = mouseX - (int)this.paletteX;
            int y = mouseY - (int)this.paletteY;
            Vector2f clickVec = new Vector2f((float)x, (float)y);
            float sqrBasicRadius = 121.0f;
            float sqrCustomRadius = 42.25f;
            boolean didSomething = false;
            for (i = 0; i < basicColorCenters.length; ++i) {
                if (!this.basicColorFlags[i] || !(this.sqrDist(clickVec, basicColorCenters[i]) <= sqrBasicRadius)) continue;
                if (mouseButton == 0) {
                    this.carriedColor = currentColor = basicColors[i];
                    this.setCarryingColor();
                    this.playSound(SoundEvents.MIX, 0.6f);
                }
                didSomething = true;
                break;
            }
            if (!didSomething) {
                for (i = 0; i < customColorCenters.length; ++i) {
                    if (!(this.sqrDist(clickVec, customColorCenters[i]) <= sqrCustomRadius)) continue;
                    if (mouseButton == 0 && this.customColors[i].getNumberOfColors() > 0) {
                        this.carriedColor = currentColor = this.customColors[i].getColor();
                        this.carriedCustomColorId = i;
                        this.setCarryingColor();
                        this.playSound(SoundEvents.MIX, 0.3f);
                    }
                    didSomething = true;
                    break;
                }
            }
            if (!didSomething && this.sqrDist(clickVec, waterCenter) <= sqrCustomRadius && mouseButton == 0) {
                this.setCarryingWater();
                this.playSound(SoundEvents.WATER);
                didSomething = true;
            }
            if (!didSomething && this.paletteComplete && !this.isCarryingWater && !this.isCarryingColor && this.inColorPicker(x, y) && mouseButton == 0) {
                this.setPickingColor();
                this.playSound(SoundEvents.COLOR_PICKER);
                didSomething = true;
            }
            if (!didSomething) {
                this.isCarryingPalette = true;
            }
        }
        return super.func_231044_a_((double)mouseX, (double)mouseY, mouseButton);
    }

    protected boolean inColorPicker(int x, int y) {
        return x >= 98 && x < 112 && y >= 62 && y < 76;
    }

    protected boolean inWater(int x, int y) {
        return this.sqrDist(new Vector2f((float)x, (float)y), waterCenter) <= 42.25f;
    }

    public boolean func_231045_a_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        return super.func_231045_a_(posX, posY, mouseButton, deltaX, deltaY);
    }

    protected void setCarryingWater() {
        this.isCarryingWater = true;
        this.isCarryingColor = false;
        this.isPickingColor = false;
    }

    protected void setCarryingColor() {
        this.isCarryingWater = false;
        this.isCarryingColor = true;
        this.isPickingColor = false;
    }

    protected void setPickingColor() {
        this.isCarryingWater = false;
        this.isCarryingColor = false;
        this.isPickingColor = true;
    }

    public boolean func_231048_c_(double posX, double posY, int mouseButton) {
        int mouseX = (int)Math.round(posX);
        int mouseY = (int)Math.round(posY);
        if (this.isCarryingColor || this.isCarryingWater) {
            if (this.paletteClick(mouseX, mouseY)) {
                float sqrCustomRadius = 42.25f;
                int x = mouseX - (int)this.paletteX;
                int y = mouseY - (int)this.paletteY;
                Vector2f clickVec = new Vector2f((float)x, (float)y);
                for (int i = 0; i < customColorCenters.length; ++i) {
                    if (!(this.sqrDist(clickVec, customColorCenters[i]) <= sqrCustomRadius)) continue;
                    PaletteUtil.CustomColor customColor = this.customColors[i];
                    if (this.isCarryingWater) {
                        customColor.reset();
                        this.playSound(SoundEvents.WATER_DROP);
                    } else if (this.carriedCustomColorId != i) {
                        customColor.mix(this.carriedColor);
                        currentColor = customColor.getColor();
                        this.playSound(SoundEvents.MIX);
                    }
                    this.dirty = true;
                    break;
                }
            }
            this.isCarryingColor = false;
            this.isCarryingWater = false;
            this.carriedCustomColorId = -1;
        }
        this.isCarryingPalette = false;
        return super.func_231048_c_(posX, posY, mouseButton);
    }

    protected void playSound(ISound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    protected void playSound(SoundEvent soundEvent) {
        this.playSound(soundEvent, 1.0f);
    }

    protected void playSound(SoundEvent soundEvent, float volume) {
        Minecraft m = Minecraft.func_71410_x();
        if (m.field_71441_e != null) {
            m.func_147118_V().func_147682_a((ISound)new SimpleSound(soundEvent, SoundCategory.MASTER, volume, 0.8f + m.field_71441_e.field_73012_v.nextFloat() * 0.4f, Minecraft.func_71410_x().field_71439_g.func_233580_cy_()));
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    boolean paletteClick(int x, int y) {
        return (double)x <= this.paletteX + 157.0 && (double)x >= this.paletteX && (double)y <= this.paletteY + 193.0 && (double)y >= this.paletteY;
    }

    float sqrDist(Vector2f a, Vector2f b) {
        return (a.field_189982_i - b.field_189982_i) * (a.field_189982_i - b.field_189982_i) + (a.field_189983_j - b.field_189983_j) * (a.field_189983_j - b.field_189983_j);
    }
}

