/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import com.google.common.collect.HashMultimap;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

class FeatureMineralVein
extends Feature<NoFeatureConfig> {
    public static HashMultimap<RegistryKey<World>, ChunkPos> veinGeneratedChunks = HashMultimap.create();

    public FeatureMineralVein() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(@Nonnull ISeedReader worldIn, @Nonnull ChunkGenerator generator, @Nonnull Random random, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        IChunk chunk;
        RegistryKey dimension;
        if (ExcavatorHandler.noiseGenerator == null) {
            ExcavatorHandler.noiseGenerator = new PerlinNoiseGenerator(new SharedSeedRandom(worldIn.func_72905_C()), IntStream.of(0));
        }
        if (!veinGeneratedChunks.containsEntry((Object)(dimension = worldIn.func_201672_e().func_234923_W_()), (Object)(chunk = worldIn.func_217349_x(pos)).func_76632_l())) {
            veinGeneratedChunks.put((Object)dimension, (Object)chunk.func_76632_l());
            ExcavatorHandler.generatePotentialVein((World)worldIn.func_201672_e(), chunk.func_76632_l(), random);
            return true;
        }
        return false;
    }
}

