/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GenericDeferredWork {
    private static final List<Runnable> TO_RUN_ON_THREAD = new ArrayList<Runnable>();
    private static boolean done = false;

    public static void enqueue(Runnable toRun) {
        Preconditions.checkState((!done ? 1 : 0) != 0);
        TO_RUN_ON_THREAD.add(toRun);
    }

    public static void registerDispenseBehavior(IItemProvider item, IDispenseItemBehavior behavior) {
        GenericDeferredWork.enqueue(() -> DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)behavior));
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent ev) {
        ev.enqueueWork(() -> {
            TO_RUN_ON_THREAD.forEach(Runnable::run);
            done = true;
        });
    }
}

