/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ClocheRecipeSerializer
extends IERecipeSerializer<ClocheRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.MetalDevices.cloche);
    }

    @Override
    public ClocheRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray results = json.getAsJsonArray("results");
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            outputs.add(this.readOutput(results.get(i)));
        }
        Ingredient seed = Ingredient.func_199802_a((JsonElement)json.get("input"));
        Ingredient soil = Ingredient.func_199802_a((JsonElement)json.get("soil"));
        int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
        ClocheRenderFunction.ClocheRenderReference renderReference = ClocheRenderFunction.ClocheRenderReference.deserialize(JSONUtils.func_152754_s((JsonObject)json, (String)"render"));
        return new ClocheRecipe(recipeId, outputs, seed, soil, time, renderReference);
    }

    @Nullable
    public ClocheRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        int outputCount = buffer.readInt();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            outputs.add(buffer.func_150791_c());
        }
        Ingredient seed = Ingredient.func_199566_b((PacketBuffer)buffer);
        Ingredient soil = Ingredient.func_199566_b((PacketBuffer)buffer);
        int time = buffer.readInt();
        ClocheRenderFunction.ClocheRenderReference renderReference = ClocheRenderFunction.ClocheRenderReference.read(buffer);
        return new ClocheRecipe(recipeId, outputs, seed, soil, time, renderReference);
    }

    public void toNetwork(PacketBuffer buffer, ClocheRecipe recipe) {
        buffer.writeInt(recipe.outputs.size());
        for (ItemStack stack : recipe.outputs) {
            buffer.func_150788_a(stack);
        }
        recipe.seed.func_199564_a(buffer);
        recipe.soil.func_199564_a(buffer);
        buffer.writeInt(recipe.time);
        recipe.renderReference.write(buffer);
    }
}

