/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.models.PrivateProperties;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class ModelConveyor
extends BakedIEModel {
    private static final ModelProperty<ConveyorHandler.IConveyorBelt> CONVEYOR_MODEL_DATA = new ModelProperty();
    public static HashMap<String, List<BakedQuad>> modelCache = new HashMap();
    public static ResourceLocation[] rl_casing = new ResourceLocation[]{new ResourceLocation("immersiveengineering", "block/conveyor/casing_top"), new ResourceLocation("immersiveengineering", "block/conveyor/casing_side"), new ResourceLocation("immersiveengineering", "block/conveyor/casing_walls"), new ResourceLocation("immersiveengineering", "block/conveyor/casing_full")};
    @Nullable
    private final ConveyorHandler.IConveyorBelt defaultBelt;
    TextureAtlasSprite tex_particle;
    static HashMap<String, IBakedModel> itemModelCache = new HashMap();
    ItemOverrideList overrideList = new ItemOverrideList(){

        @Nullable
        public IBakedModel func_239290_a_(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            IBakedModel model;
            Block b;
            ResourceLocation rlKey;
            String key = "default";
            if (stack.func_77973_b() instanceof BlockItem && (rlKey = ConveyorHandler.getType(b = ((BlockItem)stack.func_77973_b()).func_179223_d())) != null) {
                key = rlKey.toString();
            }
            if ((model = itemModelCache.get(key)) == null) {
                model = new ModelConveyor(ConveyorHandler.getConveyor(new ResourceLocation(key), null));
                itemModelCache.put(key, model);
            }
            return model;
        }
    };
    static HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap = new HashMap();

    public ModelConveyor(@Nullable ConveyorHandler.IConveyorBelt defaultBelt) {
        this.defaultBelt = defaultBelt;
    }

    public ModelConveyor() {
        this(null);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        TileEntity tile = null;
        String key = "default";
        Direction facing = Direction.NORTH;
        ConveyorHandler.IConveyorBelt conveyor = this.defaultBelt;
        if (blockState == null) {
            key = conveyor != null ? ConveyorHandler.reverseClassRegistry.get(conveyor.getClass()).toString() : "immersiveengineering:conveyor";
        } else {
            facing = (Direction)blockState.func_177229_b((Property)IEProperties.FACING_HORIZONTAL);
            if (extraData.hasProperty(CONVEYOR_MODEL_DATA)) {
                conveyor = (ConveyorHandler.IConveyorBelt)extraData.getData(CONVEYOR_MODEL_DATA);
            }
            if (extraData.hasProperty(PrivateProperties.TILEENTITY_PASSTHROUGH) && (tile = (TileEntity)extraData.getData(PrivateProperties.TILEENTITY_PASSTHROUGH)) instanceof IEBlockInterfaces.IDirectionalTile) {
                facing = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
            }
            if (conveyor == null) {
                conveyor = ConveyorHandler.getConveyor(new ResourceLocation(key), tile);
            }
            if (conveyor != null && tile != null) {
                key = conveyor.getModelCacheKey();
            }
        }
        List<Object> cachedQuads = modelCache.get(key);
        if (cachedQuads == null) {
            boolean[] blArray;
            ConveyorHandler.ConveyorDirection conDir;
            cachedQuads = Collections.synchronizedList(Lists.newArrayList());
            TransformationMatrix matrix = ClientUtils.rotateTo(facing);
            if (conveyor != null) {
                matrix = conveyor.modifyBaseRotationMatrix(matrix);
            }
            ConveyorHandler.ConveyorDirection conveyorDirection = conDir = conveyor != null ? conveyor.getConveyorDirection() : ConveyorHandler.ConveyorDirection.HORIZONTAL;
            if (conveyor != null && tile != null) {
                boolean[] blArray2 = new boolean[2];
                blArray2[0] = conveyor.renderWall(facing, 0);
                blArray = blArray2;
                blArray2[1] = conveyor.renderWall(facing, 1);
            } else {
                boolean[] blArray3 = new boolean[2];
                blArray3[0] = true;
                blArray = blArray3;
                blArray3[1] = true;
            }
            boolean[] walls = blArray;
            TextureAtlasSprite tex_conveyor = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
            TextureAtlasSprite tex_conveyor_colour = null;
            DyeColor colourStripes = null;
            if (conveyor != null) {
                tex_conveyor = ClientUtils.getSprite(tile != null ? (conveyor.isActive() ? conveyor.getActiveTexture() : conveyor.getInactiveTexture()) : conveyor.getActiveTexture());
                colourStripes = conveyor.getDyeColour();
                if (colourStripes != null) {
                    tex_conveyor_colour = ClientUtils.getSprite(conveyor.getColouredStripesTexture());
                }
            }
            cachedQuads.addAll(ModelConveyor.getBaseConveyor(facing, 1.0f, matrix, conDir, tex_conveyor, walls, new boolean[]{true, true}, tex_conveyor_colour, colourStripes));
            if (conveyor != null) {
                cachedQuads = conveyor.modifyQuads(cachedQuads);
            }
            modelCache.put(key, (List<BakedQuad>)ImmutableList.copyOf(cachedQuads));
        }
        return ImmutableList.copyOf(cachedQuads);
    }

    public static List<BakedQuad> getBaseConveyor(Direction facing, float length, TransformationMatrix matrix, ConveyorHandler.ConveyorDirection conDir, TextureAtlasSprite tex_conveyor, boolean[] walls, boolean[] corners, TextureAtlasSprite tex_conveyor_colour, @Nullable DyeColor stripeColour) {
        int i;
        int i2;
        Vector3d tmp;
        Vector3d v;
        int i3;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d[] vertices = new Vector3d[]{new Vector3d(0.0625, 0.0, (double)(1.0f - length)), new Vector3d(0.0625, 0.0, 1.0), new Vector3d(0.9375, 0.0, 1.0), new Vector3d(0.9375, 0.0, (double)(1.0f - length))};
        TextureAtlasSprite tex_casing0 = ClientUtils.getSprite(rl_casing[0]);
        TextureAtlasSprite tex_casing1 = ClientUtils.getSprite(rl_casing[1]);
        TextureAtlasSprite tex_casing2 = ClientUtils.getSprite(rl_casing[2]);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] colourStripes = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (stripeColour != null) {
            System.arraycopy(stripeColour.func_193349_f(), 0, colourStripes, 0, 3);
        }
        TextureAtlasSprite topTexture = tex_conveyor_colour != null ? tex_conveyor_colour : tex_casing2;
        float[] topColor = stripeColour != null ? colourStripes : colour;
        for (i3 = 0; i3 < 4; ++i3) {
            if (!(i3 == 0 || i3 == 3 ? conDir == ConveyorHandler.ConveyorDirection.UP : conDir == ConveyorHandler.ConveyorDirection.DOWN)) continue;
            vertices[i3] = vertices[i3].func_72441_c(0.0, (double)length, 0.0);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), tex_conveyor, new double[]{1.0, 0.0, 15.0, length * 16.0f}, colour, true));
        for (i3 = 0; i3 < vertices.length; ++i3) {
            v = vertices[i3];
            vertices[i3] = new Vector3d(v.field_72450_a < 0.5 ? 0.0 : 1.0, v.field_72448_b, v.field_72449_c);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), tex_casing2, new double[]{0.0, 0.0, 16.0, length * 16.0f}, colour, true));
        for (i3 = 0; i3 < vertices.length; ++i3) {
            vertices[i3] = vertices[i3].func_72441_c(0.0, 0.125, 0.0);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), tex_conveyor, new double[]{0.0, length * 16.0f, 16.0, 0.0}, colour, false));
        if (corners[0]) {
            vertices = new Vector3d[]{new Vector3d(0.0, 0.1875, 0.9375), new Vector3d(0.0, 0.1875, 1.0), new Vector3d(1.0, 0.1875, 1.0), new Vector3d(1.0, 0.1875, 0.9375)};
            for (i3 = 0; i3 < 4; ++i3) {
                vertices[i3] = vertices[i3].func_72441_c(0.0, i3 == 0 || i3 == 3 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length - 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.DOWN ? length : 0.0f), 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 1.0, 16.0, 0.0}, topColor, false));
        }
        if (corners[1]) {
            vertices = new Vector3d[]{new Vector3d(0.0, 0.1875, (double)(1.0f - length)), new Vector3d(0.0, 0.1875, (double)(1.0625f - length)), new Vector3d(1.0, 0.1875, (double)(1.0625f - length)), new Vector3d(1.0, 0.1875, (double)(1.0f - length))};
            for (i3 = 0; i3 < 4; ++i3) {
                vertices[i3] = vertices[i3].func_72441_c(0.0, i3 == 1 || i3 == 2 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length : 0.0f), 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 1.0, 16.0, 0.0}, topColor, false));
        }
        vertices = new Vector3d[]{new Vector3d(0.0, 0.0, (double)(1.0f - length)), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.125, 1.0), new Vector3d(0.0, 0.125, (double)(1.0f - length))};
        for (i3 = 0; i3 < 4; ++i3) {
            if (!(i3 == 0 || i3 == 3 ? conDir == ConveyorHandler.ConveyorDirection.UP : conDir == ConveyorHandler.ConveyorDirection.DOWN)) continue;
            vertices[i3] = vertices[i3].func_72441_c(0.0, (double)length, 0.0);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, false));
        for (i3 = 0; i3 < 4; ++i3) {
            v = vertices[i3];
            vertices[i3] = new Vector3d(1.0, v.field_72448_b, v.field_72449_c);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, true));
        for (i3 = 0; i3 < 4; ++i3) {
            v = vertices[i3];
            vertices[i3] = new Vector3d(v.field_72450_a, v.field_72448_b + (double)(i3 == 0 || i3 == 1 ? 0.125f : 0.0625f), v.field_72449_c);
        }
        if (corners[0]) {
            vertices = new Vector3d[]{new Vector3d(0.0, 0.125, 0.9375), new Vector3d(0.0, 0.125, 1.0), new Vector3d(0.0, 0.1875, 1.0), new Vector3d(0.0, 0.1875, 0.9375)};
            if (conDir != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                for (i3 = 0; i3 < 4; ++i3) {
                    vertices[i3] = vertices[i3].func_72441_c(0.0, i3 == 0 || i3 == 3 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? length - 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.DOWN ? length : 0.0f), 0.0);
                }
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, false));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].func_72441_c(0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                tmp = vertices[i3];
                vertices[i3] = new Vector3d(1.0, tmp.field_72448_b, tmp.field_72449_c);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].func_72441_c(-0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 0.0, 1.0, 1.0}, colour, false));
        }
        if (corners[1]) {
            vertices = new Vector3d[]{new Vector3d(0.0, 0.125, (double)(1.0f - length)), new Vector3d(0.0, 0.125, (double)(1.0625f - length)), new Vector3d(0.0, 0.1875, (double)(1.0625f - length)), new Vector3d(0.0, 0.1875, (double)(1.0f - length))};
            if (conDir != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                for (i3 = 0; i3 < 4; ++i3) {
                    vertices[i3] = vertices[i3].func_72441_c(0.0, i3 == 1 || i3 == 2 ? (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)) : (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? length : 0.0f), 0.0);
                }
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, false));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].func_72441_c(0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                tmp = vertices[i3];
                vertices[i3] = new Vector3d(1.0, tmp.field_72448_b, tmp.field_72449_c);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, true));
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].func_72441_c(-0.0625, 0.0, 0.0);
            }
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing0, new double[]{0.0, 15.0, 1.0, 16.0}, colour, false));
        }
        vertices = new Vector3d[]{new Vector3d(0.0625, 0.0, (double)(1.0f - length)), new Vector3d(0.0625, 0.125, (double)(1.0f - length)), new Vector3d(0.9375, 0.125, (double)(1.0f - length)), new Vector3d(0.9375, 0.0, (double)(1.0f - length))};
        if (conDir == ConveyorHandler.ConveyorDirection.UP) {
            for (i3 = 0; i3 < vertices.length; ++i3) {
                vertices[i3] = vertices[i3].func_72441_c(0.0, (double)length, 0.0);
            }
        }
        double frontUMax = (1.0f - length) * 16.0f;
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_conveyor, new double[]{1.0, frontUMax + 2.0, 15.0, frontUMax}, colour, false));
        for (i2 = 0; i2 < 4; ++i2) {
            vertices[i2] = new Vector3d(vertices[i2].func_82615_a() < 0.5 ? 0.0 : 1.0, vertices[i2].func_82617_b() + (double)(i2 == 1 || i2 == 2 ? 0.0625f : 0.0f), vertices[i2].field_72449_c);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing2, new double[]{0.0, 3.0, 16.0, 0.0}, colour, false));
        for (i2 = 0; i2 < vertices.length; ++i2) {
            vertices[i2] = vertices[i2].func_72441_c(0.0, (double)(conDir == ConveyorHandler.ConveyorDirection.UP ? -0.0625f : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? 0.0625f : 0.0f)), 0.0625);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing2, new double[]{0.0, 3.0, 16.0, 0.0}, colour, true));
        for (i2 = 0; i2 < 4; ++i2) {
            Vector3d v2 = vertices[i2];
            v2 = new Vector3d(v2.func_82615_a() < 0.5 ? 0.0625 : 0.9375, v2.func_82617_b() - (double)(i2 == 1 || i2 == 2 ? 0.0625f : 0.0f), v2.field_72449_c);
            if (conDir == ConveyorHandler.ConveyorDirection.UP) {
                v2 = v2.func_72441_c(0.0, (double)(-(length - 0.0625f)), 0.0);
            }
            if (conDir == ConveyorHandler.ConveyorDirection.DOWN) {
                v2 = v2.func_72441_c(0.0, (double)(length - 0.0625f), 0.0);
            }
            vertices[i2] = v2 = v2.func_72441_c(0.0, 0.0, (double)(length - 0.0625f));
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), facing.func_176734_d(), tex_conveyor, new double[]{1.0, 0.0, 15.0, 2.0}, colour, true));
        for (i2 = 0; i2 < 4; ++i2) {
            vertices[i2] = new Vector3d(vertices[i2].func_82615_a() < 0.5 ? 0.0 : 1.0, vertices[i2].func_82617_b() + (double)(i2 == 1 || i2 == 2 ? 0.0625f : 0.0f), vertices[i2].field_72449_c);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), facing.func_176734_d(), tex_casing2, new double[]{0.0, 0.0, 16.0, 3.0}, colour, true));
        for (i2 = 0; i2 < vertices.length; ++i2) {
            vertices[i2] = vertices[i2].func_72441_c(0.0, conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625 : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? -0.0625 : 0.0), -0.0625);
        }
        quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), facing.func_176734_d(), tex_casing2, new double[]{0.0, 0.0, 16.0, 3.0}, colour, false));
        float wallLength = length - 0.125f;
        vertices = new Vector3d[]{new Vector3d(0.0, 0.1875, (double)(0.9375f - wallLength)), new Vector3d(0.0, 0.1875, 0.9375), new Vector3d(0.0625, 0.1875, 0.9375), new Vector3d(0.0625, 0.1875, (double)(0.9375f - wallLength))};
        Vector3d[] vertices2 = new Vector3d[]{new Vector3d(0.0, 0.125, (double)(0.9375f - wallLength)), new Vector3d(0.0, 0.125, 0.9375), new Vector3d(0.0, 0.1875, 0.9375), new Vector3d(0.0, 0.1875, (double)(0.9375f - wallLength))};
        Vector3d[] vertices3 = new Vector3d[]{new Vector3d(0.0625, 0.125, (double)(0.9375f - wallLength)), new Vector3d(0.0625, 0.125, 0.9375), new Vector3d(0.0625, 0.1875, 0.9375), new Vector3d(0.0625, 0.1875, (double)(0.9375f - wallLength))};
        for (i = 0; i < 4; ++i) {
            if (conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL) continue;
            float f = i == 0 || i == 3 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? length - 0.0625f : 0.0625f) : (conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625f : length - 0.0625f);
            vertices[i] = vertices[i].func_72441_c(0.0, (double)f, 0.0);
            vertices2[i] = vertices2[i].func_72441_c(0.0, (double)f, 0.0);
            vertices3[i] = vertices3[i].func_72441_c(0.0, (double)f, 0.0);
        }
        if (walls[0]) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 15.0, 1.0, 1.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices3), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, true));
        }
        for (i = 0; i < 4; ++i) {
            vertices[i] = vertices[i].func_72441_c(0.9375, 0.0, 0.0);
            vertices2[i] = vertices2[i].func_72441_c(0.9375, 0.0, 0.0);
            vertices3[i] = vertices3[i].func_72441_c(0.9375, 0.0, 0.0);
        }
        if (walls[1]) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{15.0, 15.0, 16.0, 1.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertices3), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, true));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.tex_particle == null) {
            this.tex_particle = ClientUtils.getSprite(new ResourceLocation("immersiveengineering", "block/conveyor/off"));
        }
        return this.tex_particle;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        Matrix4 matrix = transformationMap.containsKey(cameraTransformType) ? transformationMap.get(cameraTransformType) : new Matrix4();
        matrix.toTransformationMatrix().push(mat);
        return this;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        Block b = state.func_177230_c();
        ResourceLocation conveyorName = ConveyorHandler.getType(b);
        if (conveyorName != null) {
            ConveyorHandler.IConveyorBelt belt = ConveyorHandler.getConveyor(conveyorName, world.func_175625_s(pos));
            return CombinedModelData.combine(tileData, new SinglePropertyModelData<ConveyorHandler.IConveyorBelt>(belt, CONVEYOR_MODEL_DATA));
        }
        return tileData;
    }

    static {
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.GUI, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-20.0), 0.0, 0.0, 1.0).rotate(Math.toRadians(20.0), 1.0, 0.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIXED, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.PI, 0.0, 1.0, 0.0).translate(0.0, 0.0, 0.3125));
        transformationMap.put(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(0.25, 0.25, 0.25));
    }

    public static class ConveyorLoader
    implements IModelLoader<RawConveyorModel> {
        public static final ResourceLocation LOCATION = new ResourceLocation("immersiveengineering", "models/conveyor");

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public RawConveyorModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new RawConveyorModel();
        }
    }

    public static class RawConveyorModel
    implements IModelGeometry<RawConveyorModel> {
        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new ModelConveyor();
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return ImmutableList.of();
        }
    }
}

