/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.BinaryHeap;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.AbstractObject2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyTransferHandler
extends LocalNetworkHandler
implements IWorldTickable {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "energy_transfer");
    private final Map<ConnectionPoint, Map<ConnectionPoint, Path>> energyPaths = new HashMap<ConnectionPoint, Map<ConnectionPoint, Path>>();
    private Object2DoubleOpenHashMap<Connection> transferredNextTick = new Object2DoubleOpenHashMap();
    private Object2DoubleMap<Connection> transferredLastTick = new Object2DoubleOpenHashMap();
    private final Map<ConnectionPoint, EnergyConnector> sources = new HashMap<ConnectionPoint, EnergyConnector>();
    private final Map<ConnectionPoint, EnergyConnector> sinks = new HashMap<ConnectionPoint, EnergyConnector>();
    private boolean sourceSinkMapInitialized = true;

    public EnergyTransferHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        super(net, global);
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        this.reset();
        return this;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectionAdded(Connection c) {
        this.reset();
    }

    @Override
    public void onConnectionRemoved(Connection c) {
        this.reset();
    }

    @Override
    public void update(World w) {
        this.transferPower();
        this.transferredLastTick = this.transferredNextTick;
        this.transferredNextTick = new Object2DoubleOpenHashMap();
        this.burnOverloaded(w);
    }

    public Object2DoubleMap<Connection> getTransferredNextTick() {
        return this.transferredNextTick;
    }

    public Object2DoubleMap<Connection> getTransferredLastTick() {
        return Object2DoubleMaps.unmodifiable(this.transferredLastTick);
    }

    private void reset() {
        this.energyPaths.clear();
        this.transferredNextTick.clear();
        this.transferredLastTick.clear();
        this.sinks.clear();
        this.sources.clear();
        this.sourceSinkMapInitialized = false;
    }

    public Map<ConnectionPoint, EnergyConnector> getSources() {
        this.updateSourcesAndSinks();
        return this.sources;
    }

    @Nullable
    public Path getPath(ConnectionPoint source, ConnectionPoint sink) {
        return this.getPathsFromSource(source).get(sink);
    }

    public Map<ConnectionPoint, Path> getPathsFromSource(ConnectionPoint source) {
        Map<ConnectionPoint, Path> mutableResult = this.energyPaths.get(source);
        if (mutableResult == null) {
            Map<ConnectionPoint, Path> finalMutableResult = mutableResult = new HashMap<ConnectionPoint, Path>();
            this.runDijkstraWithSource(source, p -> {
                finalMutableResult.put(p.end, (Path)p);
                return false;
            });
            this.energyPaths.put(source, mutableResult);
        }
        return Collections.unmodifiableMap(mutableResult);
    }

    private void updateSourcesAndSinks() {
        if (this.sourceSinkMapInitialized) {
            return;
        }
        this.sourceSinkMapInitialized = true;
        for (ConnectionPoint cp : this.localNet.getConnectionPoints()) {
            IImmersiveConnectable iic = this.localNet.getConnector(cp);
            if (!(iic instanceof EnergyConnector)) continue;
            EnergyConnector energyIIC = (EnergyConnector)iic;
            if (energyIIC.isSink(cp)) {
                this.sinks.put(cp, energyIIC);
            }
            if (!energyIIC.isSource(cp)) continue;
            this.sources.put(cp, energyIIC);
        }
    }

    private void runDijkstraWithSource(ConnectionPoint source, Predicate<Path> stopAfter) {
        HashMap<ConnectionPoint, Path> shortestKnown = new HashMap<ConnectionPoint, Path>();
        BinaryHeap<ConnectionPoint> heap = new BinaryHeap<ConnectionPoint>(Comparator.comparingDouble(end -> ((Path)shortestKnown.get((Object)end)).loss));
        HashMap<ConnectionPoint, BinaryHeap.HeapEntry<ConnectionPoint>> entryMap = new HashMap<ConnectionPoint, BinaryHeap.HeapEntry<ConnectionPoint>>();
        shortestKnown.put(source, new Path(source));
        entryMap.put(source, heap.insert(source));
        while (!heap.empty()) {
            ConnectionPoint endPoint = heap.extractMin();
            entryMap.remove(endPoint);
            Path shortest = (Path)shortestKnown.get(endPoint);
            if (stopAfter.test(shortest)) {
                return;
            }
            if (shortest.loss >= 1.0) break;
            for (Connection next : this.localNet.getConnections(endPoint)) {
                Path alternative = shortest.append(next, this.sinks.containsKey(next.getOtherEnd(shortest.end)));
                if (!shortestKnown.containsKey(alternative.end)) {
                    shortestKnown.put(alternative.end, alternative);
                    entryMap.put(alternative.end, heap.insert(alternative.end));
                    continue;
                }
                Path oldPath = (Path)shortestKnown.get(alternative.end);
                if (!(alternative.loss < oldPath.loss)) continue;
                shortestKnown.put(alternative.end, alternative);
                heap.decreaseKey((BinaryHeap.HeapEntry)entryMap.get(alternative.end));
            }
        }
    }

    private void transferPower() {
        this.updateSourcesAndSinks();
        for (Map.Entry<ConnectionPoint, EnergyConnector> sourceEntry : this.sources.entrySet()) {
            ConnectionPoint sourceCp = sourceEntry.getKey();
            EnergyConnector source = sourceEntry.getValue();
            int available = source.getAvailableEnergy();
            if (available <= 0) continue;
            Map<ConnectionPoint, Path> pathsToSinks = this.getPathsFromSource(sourceCp);
            double maxSum = 0.0;
            ArrayList<AbstractObject2DoubleMap.BasicEntry> maxOut = new ArrayList<AbstractObject2DoubleMap.BasicEntry>(this.sinks.size());
            for (Map.Entry<ConnectionPoint, EnergyConnector> sinkEntry : this.sinks.entrySet()) {
                EnergyConnector energyConnector;
                int requested;
                Path p = pathsToSinks.get(sinkEntry.getKey());
                if (p == null || (requested = (energyConnector = sinkEntry.getValue()).getRequestedEnergy()) <= 0) continue;
                double requiredAtSource = Math.min((double)requested / (1.0 - p.loss), (double)available);
                maxOut.add(new AbstractObject2DoubleMap.BasicEntry((Object)p, requiredAtSource));
                maxSum += requiredAtSource;
            }
            if (maxSum == 0.0) continue;
            double allowedFactor = Math.min(1.0, (double)available / maxSum);
            for (Object2DoubleMap.Entry entry : maxOut) {
                Path p = (Path)entry.getKey();
                double atSource = allowedFactor * entry.getDoubleValue();
                double currentLoss = 0.0;
                ConnectionPoint currentPoint = sourceCp;
                for (Connection c : p.conns) {
                    IImmersiveConnectable iic;
                    currentPoint = c.getOtherEnd(currentPoint);
                    double availableAtPoint = atSource * (1.0 - (currentLoss += EnergyTransferHandler.getBasicLoss(c)));
                    this.transferredNextTick.addTo((Object)c, availableAtPoint);
                    if (currentPoint.equals(p.end) || !((iic = this.localNet.getConnector(currentPoint)) instanceof EnergyConnector)) continue;
                    ((EnergyConnector)iic).onEnergyPassedThrough(availableAtPoint);
                }
                EnergyConnector sink = this.sinks.get(p.end);
                sink.insertEnergy((int)(atSource * (1.0 - currentLoss)));
            }
            if (allowedFactor < 1.0) {
                source.extractEnergy(available);
                continue;
            }
            source.extractEnergy(MathHelper.func_76143_f((double)maxSum));
        }
    }

    private void burnOverloaded(World world) {
        Preconditions.checkNotNull((Object)this.globalNet);
        ArrayList<ImmutablePair> toBurn = new ArrayList<ImmutablePair>();
        for (Object2DoubleMap.Entry entry : this.transferredLastTick.object2DoubleEntrySet()) {
            Connection c = (Connection)entry.getKey();
            double transferred = entry.getDoubleValue();
            if (!(c.type instanceof IEnergyWire) || !((IEnergyWire)((Object)c.type)).shouldBurn(c, transferred)) continue;
            toBurn.add(new ImmutablePair((Object)c, (Object)transferred));
        }
        for (Pair pair : toBurn) {
            ((IEnergyWire)((Object)((Connection)pair.getLeft()).type)).burn((Connection)pair.getLeft(), (Double)pair.getRight(), this.globalNet, world);
        }
    }

    private static double getBasicLoss(Connection c) {
        if (c.isInternal()) {
            return 0.0;
        }
        if (c.type instanceof IEnergyWire) {
            return ((IEnergyWire)((Object)c.type)).getBasicLossRate(c);
        }
        return Double.POSITIVE_INFINITY;
    }

    public static class Path {
        public final Connection[] conns;
        public final ConnectionPoint start;
        public final ConnectionPoint end;
        public final double loss;
        public final boolean isPathToSink;

        private Path(Connection[] conns, ConnectionPoint start, ConnectionPoint end, double loss, boolean isPathToSink) {
            this.conns = conns;
            this.start = start;
            this.end = end;
            this.loss = loss;
            this.isPathToSink = isPathToSink;
        }

        public Path(ConnectionPoint point) {
            this(new Connection[0], point, point, 0.0, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return Arrays.equals(this.conns, path.conns);
        }

        public int hashCode() {
            return Arrays.hashCode(this.conns);
        }

        public Path append(Connection next, boolean isPathToSink) {
            ConnectionPoint newEnd = next.getOtherEnd(this.end);
            double newLoss = this.loss + EnergyTransferHandler.getBasicLoss(next);
            Connection[] newPath = Arrays.copyOf(this.conns, this.conns.length + 1);
            newPath[newPath.length - 1] = next;
            return new Path(newPath, this.start, newEnd, newLoss, isPathToSink);
        }
    }

    public static interface EnergyConnector
    extends IImmersiveConnectable {
        public boolean isSource(ConnectionPoint var1);

        public boolean isSink(ConnectionPoint var1);

        default public int getAvailableEnergy() {
            return 0;
        }

        default public int getRequestedEnergy() {
            return 0;
        }

        default public void insertEnergy(int amount) {
        }

        default public void extractEnergy(int amount) {
        }

        default public void onEnergyPassedThrough(double amount) {
        }
    }

    public static interface IEnergyWire {
        public int getTransferRate();

        public double getBasicLossRate(Connection var1);

        public double getLossRate(Connection var1, int var2);

        default public boolean shouldBurn(Connection c, double power) {
            return power > (double)this.getTransferRate();
        }

        default public void burn(Connection c, double power, GlobalWireNetwork net, World w) {
            net.removeConnection(c);
            if (c.hasCatenaryData() && w instanceof ServerWorld) {
                int numPoints = 16;
                Vector3d offset = Vector3d.func_237491_b_((Vector3i)c.getEndA().getPosition());
                for (int i = 1; i < 16; ++i) {
                    double posOnWire = (double)i / 16.0;
                    Vector3d pos = c.getPoint(posOnWire, c.getEndA()).func_178787_e(offset);
                    ((ServerWorld)w).func_195598_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
    }
}

