/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.harvest;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.Util;

public class HasteModifier
extends IncrementalArmorLevelModifier {
    private static final ITextComponent MINING_SPEED = TConstruct.makeTranslation("modifier", "fake_attribute.mining_speed");
    public static final TinkerDataCapability.TinkerDataKey<Float> HASTE = TConstruct.createKey("haste");

    public HasteModifier() {
        super(8325377, HASTE);
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        if (level <= 5) {
            return this.applyStyle((IFormattableTextComponent)new TranslationTextComponent(this.getTranslationKey() + "." + level));
        }
        return super.getDisplayName(level);
    }

    @Override
    public void addToolStats(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
        float scaledLevel = this.getScaledLevel(persistentData, level);
        ToolStats.MINING_SPEED.add(builder, scaledLevel * 5.0f);
        ToolStats.ATTACK_SPEED.multiply(builder, 1.0f + scaledLevel * 0.05f);
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag flag) {
        double boost;
        if (tool.hasTag((ITag<Item>)TinkerTags.Items.ARMOR) && (boost = 0.1 * (double)this.getScaledLevel(tool, level)) != 0.0) {
            tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.PERCENT_BOOST_FORMAT.format(boost)).func_240702_b_(" ").func_230529_a_(MINING_SPEED)));
        }
    }
}

