/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.effect.MagneticEffect;

public class MagneticModifier
extends TotalArmorLevelModifier
implements IHarvestModifier,
IShearModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> MAGNET = TConstruct.createKey("magnet");

    public MagneticModifier() {
        super(0x720000, MAGNET);
        MinecraftForge.EVENT_BUS.addListener(MagneticModifier::onLivingTick);
    }

    @Override
    public void afterBlockBreak(IModifierToolStack tool, int level, ToolHarvestContext context) {
        if (!context.isAOE()) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply(context.getLiving(), 30, level - 1);
        }
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack()) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply(context.getAttacker(), 30, level - 1);
        }
        return 0;
    }

    @Override
    public void afterHarvest(IModifierToolStack tool, int level, ItemUseContext context, ServerWorld world, BlockState state, BlockPos pos) {
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply((LivingEntity)player, 30, level - 1);
        }
    }

    @Override
    public void afterShearEntity(IModifierToolStack tool, int level, PlayerEntity player, Entity entity, boolean isTarget) {
        if (isTarget) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply((LivingEntity)player, 30, level - 1);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IHarvestModifier.class || type == IShearModifier.class) {
            return (T)this;
        }
        return null;
    }

    private static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        int level;
        LivingEntity entity = event.getEntityLiving();
        if ((entity.field_70173_aa & 1) == 0 && (level = ModifierUtil.getTotalModifierLevel(entity, MAGNET)) > 0) {
            MagneticModifier.applyMagnet(entity, level);
        }
    }

    public static void applyMagnet(LivingEntity entity, int amplifier) {
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        float range = 3.0f + 1.0f * (float)amplifier;
        List items = entity.func_130014_f_().func_217357_a(ItemEntity.class, new AxisAlignedBB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
        int pulled = 0;
        for (ItemEntity item : items) {
            if (item.func_92059_d().func_190926_b() || !item.func_70089_S()) continue;
            Vector3d vec = entity.func_213303_ch().func_178786_a(item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_()).func_72432_b().func_186678_a((double)(0.05f + (float)amplifier * 0.05f));
            if (!item.func_189652_ae()) {
                vec = vec.func_72441_c(0.0, (double)0.04f, 0.0);
            }
            item.func_213317_d(item.func_213322_ci().func_178787_e(vec));
            if ((pulled += item.func_92059_d().func_190916_E()) <= 200) continue;
            break;
        }
    }
}

