/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class SelfDestructiveModifier
extends SingleUseModifier
implements IArmorInteractModifier {
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("68ee3026-1d50-4eb4-914e-a8b05fbfdb71"), TConstruct.prefix("self_destruct_slowdown"), (double)-0.9f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final DamageSource SELF_DESTRUCT = new DamageSource(TConstruct.prefix("self_destruct")).func_76348_h().func_94540_d();
    private static final TinkerDataCapability.TinkerDataKey<Integer> FUSE_FINISH = TConstruct.createKey("self_destruct_finish");

    public SelfDestructiveModifier() {
        super(9820046);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, SelfDestructiveModifier::playerTick);
    }

    @Override
    public boolean startArmorInteract(IModifierToolStack tool, int level, PlayerEntity player, EquipmentSlotType slot) {
        if (player.func_225608_bj_()) {
            player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(FUSE_FINISH, player.field_70173_aa + 30));
            player.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            ModifiableAttributeInstance instance = player.func_233645_dx_().func_233779_a_(Attributes.field_233821_d_);
            if (instance != null) {
                instance.func_233767_b_(SPEED_MODIFIER);
            }
            return true;
        }
        return false;
    }

    private static void restoreSpeed(LivingEntity livingEntity) {
        ModifiableAttributeInstance instance = livingEntity.func_233645_dx_().func_233779_a_(Attributes.field_233821_d_);
        if (instance != null) {
            instance.func_111124_b(SPEED_MODIFIER);
        }
    }

    @Override
    public void stopArmorInteract(IModifierToolStack tool, int level, PlayerEntity player, EquipmentSlotType slot) {
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.remove(FUSE_FINISH));
        SelfDestructiveModifier.restoreSpeed((LivingEntity)player);
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        context.getTinkerData().ifPresent(data -> data.remove(FUSE_FINISH));
        SelfDestructiveModifier.restoreSpeed(context.getEntity());
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return SelfDestructiveModifier.tryModuleMatch(type, IArmorInteractModifier.class, this);
    }

    private static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.func_130014_f_().field_72995_K) {
            event.player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                Integer fuseFinish = data.get(FUSE_FINISH);
                if (fuseFinish != null && fuseFinish <= event.player.field_70173_aa) {
                    event.player.field_70170_p.func_217385_a((Entity)event.player, event.player.func_226277_ct_(), event.player.func_226278_cu_(), event.player.func_226281_cx_(), 3.0f, Explosion.Mode.DESTROY);
                    event.player.func_70097_a(SELF_DESTRUCT, 99999.0f);
                    if (event.player.func_110143_aJ() > 0.0f) {
                        SelfDestructiveModifier.restoreSpeed((LivingEntity)event.player);
                    }
                    data.remove(FUSE_FINISH);
                }
            });
        }
    }
}

