/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.traits.skull.ChrysophiliteModifier;

public class ChrysophiliteBonusFunction
extends LootFunction {
    public static final ResourceLocation ID = TConstruct.getResource("chrysophilite_bonus");
    public static final Serializer SERIALIZER = new Serializer();
    private final ApplyBonus.IFormula formula;
    private final boolean includeBase;

    protected ChrysophiliteBonusFunction(ILootCondition[] conditions, ApplyBonus.IFormula formula, boolean includeBase) {
        super(conditions);
        this.formula = formula;
        this.includeBase = includeBase;
    }

    public static LootFunction.Builder<?> builder(ApplyBonus.IFormula formula, boolean includeBase) {
        return ChrysophiliteBonusFunction.func_215860_a(conditions -> new ChrysophiliteBonusFunction((ILootCondition[])conditions, formula, includeBase));
    }

    public static LootFunction.Builder<?> binomialWithBonusCount(float probability, int extra, boolean includeBase) {
        return ChrysophiliteBonusFunction.builder((ApplyBonus.IFormula)new ApplyBonus.BinomialWithBonusCountFormula(extra, probability), includeBase);
    }

    public static LootFunction.Builder<?> oreDrops(boolean includeBase) {
        return ChrysophiliteBonusFunction.builder((ApplyBonus.IFormula)new ApplyBonus.OreDropsFormula(), includeBase);
    }

    public static LootFunction.Builder<?> uniformBonusCount(int bonusMultiplier, boolean includeBase) {
        return ChrysophiliteBonusFunction.builder((ApplyBonus.IFormula)new ApplyBonus.UniformBonusCountFormula(bonusMultiplier), includeBase);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        int level = ChrysophiliteModifier.getTotalGold((Entity)context.func_216031_c(LootParameters.field_216281_a));
        if (!this.includeBase) {
            --level;
        }
        if (level > 0) {
            stack.func_190920_e(this.formula.func_216204_a(context.func_216032_b(), stack.func_190916_E(), level));
        }
        return stack;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216281_a);
    }

    public LootFunctionType func_230425_b_() {
        return TinkerModifiers.chrysophiliteBonusFunction;
    }

    private static class Serializer
    extends LootFunction.Serializer<ChrysophiliteBonusFunction> {
        private Serializer() {
        }

        public void serialize(JsonObject json, ChrysophiliteBonusFunction loot, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)loot, context);
            json.addProperty("formula", loot.formula.func_216203_a().toString());
            JsonObject parameters = new JsonObject();
            loot.formula.func_216202_a(parameters, context);
            if (parameters.size() > 0) {
                json.add("parameters", (JsonElement)parameters);
            }
            json.addProperty("include_base", Boolean.valueOf(loot.includeBase));
        }

        public ChrysophiliteBonusFunction deserialize(JsonObject json, JsonDeserializationContext context, ILootCondition[] conditions) {
            ResourceLocation id = JsonHelper.getResourceLocation((JsonObject)json, (String)"formula");
            ApplyBonus.IFormulaDeserializer deserializer = (ApplyBonus.IFormulaDeserializer)ApplyBonus.field_215875_a.get(id);
            if (deserializer == null) {
                throw new JsonParseException("Invalid formula id: " + id);
            }
            JsonObject parameters = json.has("parameters") ? JSONUtils.func_152754_s((JsonObject)json, (String)"parameters") : new JsonObject();
            ApplyBonus.IFormula formula = deserializer.deserialize(parameters, context);
            boolean includeBase = JSONUtils.func_151209_a((JsonObject)json, (String)"include_base", (boolean)true);
            return new ChrysophiliteBonusFunction(conditions, formula, includeBase);
        }
    }
}

