/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.tools.logic.ModifierMaxLevel;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;
import slimeknights.tconstruct.tools.modifiers.defense.ProtectionModifier;

public class DragonbornModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> DRAGONBORN = TConstruct.createKey("dragonborn");

    public DragonbornModifier() {
        super(0x232323, DRAGONBORN);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CriticalHitEvent.class, DragonbornModifier::onCritical);
    }

    @Override
    protected ModifierMaxLevel createData() {
        return new ModifierMaxLevel();
    }

    private static boolean isAirborne(LivingEntity living) {
        return !living.func_233570_aj_() && !living.func_70617_f_() && !living.func_70090_H() && !living.func_184218_aH();
    }

    @Override
    public float getProtectionModifier(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float modifierValue) {
        if (!source.func_151517_h() && !source.func_76357_e() && DragonbornModifier.isAirborne(context.getEntity())) {
            modifierValue = (float)((double)modifierValue + (double)this.getScaledLevel(tool, level) * 2.5);
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag tooltipFlag) {
        ProtectionModifier.addResistanceTooltip(this, tool, level, 2.5f, tooltip);
    }

    private static void onCritical(CriticalHitEvent event) {
        if (event.getResult() != Event.Result.DENY) {
            boolean isCritical;
            LivingEntity living = event.getEntityLiving();
            boolean bl = isCritical = event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW;
            if (!isCritical && DragonbornModifier.isAirborne(living)) {
                isCritical = true;
                event.setResult(Event.Result.ALLOW);
            }
            if (isCritical) {
                living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                    float max;
                    ModifierMaxLevel dragonborn = data.get(DRAGONBORN);
                    if (dragonborn != null && (max = dragonborn.getMax()) > 0.0f) {
                        event.setDamageModifier(event.getDamageModifier() + max * 0.05f);
                    }
                });
            }
        }
    }
}

