/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.function.Supplier;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.util.SupplierItemGroup;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.loot.AddToolDataFunction;
import slimeknights.tconstruct.library.loot.RandomMaterial;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolPredicate;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.tools.ArmorDefinitions;
import slimeknights.tconstruct.tools.ToolDefinitions;
import slimeknights.tconstruct.tools.data.ModifierRecipeProvider;
import slimeknights.tconstruct.tools.data.StationSlotLayoutProvider;
import slimeknights.tconstruct.tools.data.ToolDefinitionDataProvider;
import slimeknights.tconstruct.tools.data.ToolsRecipeProvider;
import slimeknights.tconstruct.tools.data.material.MaterialDataProvider;
import slimeknights.tconstruct.tools.data.material.MaterialRecipeProvider;
import slimeknights.tconstruct.tools.data.material.MaterialRenderInfoProvider;
import slimeknights.tconstruct.tools.data.material.MaterialStatsDataProvider;
import slimeknights.tconstruct.tools.data.material.MaterialTraitsDataProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerMaterialSpriteProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;
import slimeknights.tconstruct.tools.inventory.ToolContainer;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.SlimelytraItem;
import slimeknights.tconstruct.tools.item.SlimeskullItem;
import slimeknights.tconstruct.tools.item.broad.BroadAxeTool;
import slimeknights.tconstruct.tools.item.broad.CleaverTool;
import slimeknights.tconstruct.tools.item.broad.ExcavatorTool;
import slimeknights.tconstruct.tools.item.broad.ScytheTool;
import slimeknights.tconstruct.tools.item.broad.SledgeHammerTool;
import slimeknights.tconstruct.tools.item.broad.VeinHammerTool;
import slimeknights.tconstruct.tools.item.small.DaggerTool;
import slimeknights.tconstruct.tools.item.small.HandAxeTool;
import slimeknights.tconstruct.tools.item.small.HarvestTool;
import slimeknights.tconstruct.tools.item.small.KamaTool;
import slimeknights.tconstruct.tools.item.small.MattockTool;
import slimeknights.tconstruct.tools.item.small.PickaxeTool;
import slimeknights.tconstruct.tools.item.small.SweepingSwordTool;
import slimeknights.tconstruct.tools.item.small.SwordTool;
import slimeknights.tconstruct.tools.logic.EquipmentChangeWatcher;

public final class TinkerTools
extends TinkerModule {
    public static final ItemGroup TAB_TOOLS = new SupplierItemGroup("tconstruct", "tools", () -> ((HarvestTool)pickaxe.get()).getRenderTool());
    public static LootFunctionType lootAddToolData;
    private static final Supplier<Item.Properties> TOOL;
    public static final ItemObject<HarvestTool> pickaxe;
    public static final ItemObject<SledgeHammerTool> sledgeHammer;
    public static final ItemObject<VeinHammerTool> veinHammer;
    public static final ItemObject<MattockTool> mattock;
    public static final ItemObject<ExcavatorTool> excavator;
    public static final ItemObject<HandAxeTool> handAxe;
    public static final ItemObject<BroadAxeTool> broadAxe;
    public static final ItemObject<KamaTool> kama;
    public static final ItemObject<KamaTool> scythe;
    public static final ItemObject<SwordTool> dagger;
    public static final ItemObject<SweepingSwordTool> sword;
    public static final ItemObject<CleaverTool> cleaver;
    public static final ItemObject<ModifiableItem> flintAndBronze;
    public static final EnumObject<ArmorSlotType, ModifiableArmorItem> travelersGear;
    public static final EnumObject<ArmorSlotType, ModifiableArmorItem> plateArmor;
    public static final EnumObject<ArmorSlotType, ModifiableArmorItem> slimesuit;
    public static final RegistryObject<BasicParticleType> hammerAttackParticle;
    public static final RegistryObject<BasicParticleType> axeAttackParticle;
    public static final RegistryObject<EntityType<IndestructibleItemEntity>> indestructibleItem;
    public static final RegistryObject<ContainerType<ToolContainer>> toolContainer;

    public TinkerTools() {
        SlotType.init();
        BlockSideHitListener.init();
        ModifierLootingHandler.init();
        RandomMaterial.init();
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        EquipmentChangeWatcher.register();
        ToolCapabilityProvider.register(ToolFluidCapability.Provider::new);
        ToolCapabilityProvider.register(ToolInventoryCapability.Provider::new);
    }

    @SubscribeEvent
    void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        ItemPredicate.register((ResourceLocation)ToolPredicate.ID, ToolPredicate::deserialize);
        lootAddToolData = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)AddToolDataFunction.ID, (Object)new LootFunctionType((ILootSerializer)AddToolDataFunction.SERIALIZER));
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new ToolsRecipeProvider(generator));
            generator.func_200390_a((IDataProvider)new MaterialRecipeProvider(generator));
            generator.func_200390_a((IDataProvider)new ModifierRecipeProvider(generator));
            MaterialDataProvider materials = new MaterialDataProvider(generator);
            generator.func_200390_a((IDataProvider)materials);
            generator.func_200390_a((IDataProvider)new MaterialStatsDataProvider(generator, materials));
            generator.func_200390_a((IDataProvider)new MaterialTraitsDataProvider(generator, materials));
            generator.func_200390_a((IDataProvider)new ToolDefinitionDataProvider(generator));
            generator.func_200390_a((IDataProvider)new StationSlotLayoutProvider(generator));
        }
        if (event.includeClient()) {
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            TinkerMaterialSpriteProvider materialSprites = new TinkerMaterialSpriteProvider();
            TinkerPartSpriteProvider partSprites = new TinkerPartSpriteProvider();
            generator.func_200390_a((IDataProvider)new MaterialRenderInfoProvider(generator, materialSprites));
            generator.func_200390_a((IDataProvider)new GeneratorPartTextureJsonGenerator(generator, "tconstruct", partSprites));
            generator.func_200390_a((IDataProvider)new MaterialPartTextureGenerator(generator, existingFileHelper, partSprites, materialSprites));
        }
    }

    static {
        TOOL = () -> new Item.Properties().func_200916_a(TAB_TOOLS);
        pickaxe = ITEMS.register("pickaxe", () -> new PickaxeTool(TOOL.get().addToolType(ToolType.PICKAXE, 0), ToolDefinitions.PICKAXE));
        sledgeHammer = ITEMS.register("sledge_hammer", () -> new SledgeHammerTool(TOOL.get().addToolType(ToolType.PICKAXE, 0), ToolDefinitions.SLEDGE_HAMMER));
        veinHammer = ITEMS.register("vein_hammer", () -> new VeinHammerTool(TOOL.get().addToolType(ToolType.PICKAXE, 0), ToolDefinitions.VEIN_HAMMER));
        mattock = ITEMS.register("mattock", () -> new MattockTool(TOOL.get().addToolType(ToolType.SHOVEL, 0), ToolDefinitions.MATTOCK));
        excavator = ITEMS.register("excavator", () -> new ExcavatorTool(TOOL.get().addToolType(ToolType.SHOVEL, 0), ToolDefinitions.EXCAVATOR));
        handAxe = ITEMS.register("hand_axe", () -> new HandAxeTool(TOOL.get().addToolType(ToolType.AXE, 0), ToolDefinitions.HAND_AXE));
        broadAxe = ITEMS.register("broad_axe", () -> new BroadAxeTool(TOOL.get().addToolType(ToolType.AXE, 0), ToolDefinitions.BROAD_AXE));
        kama = ITEMS.register("kama", () -> new KamaTool(TOOL.get().addToolType(ToolType.HOE, 0).addToolType(ToolType.get((String)"shears"), 0), ToolDefinitions.KAMA));
        scythe = ITEMS.register("scythe", () -> new ScytheTool(TOOL.get().addToolType(ToolType.HOE, 0), ToolDefinitions.SCYTHE));
        dagger = ITEMS.register("dagger", () -> new DaggerTool(TOOL.get().addToolType(SwordTool.TOOL_TYPE, 0), ToolDefinitions.DAGGER));
        sword = ITEMS.register("sword", () -> new SweepingSwordTool(TOOL.get().addToolType(SwordTool.TOOL_TYPE, 0), ToolDefinitions.SWORD));
        cleaver = ITEMS.register("cleaver", () -> new CleaverTool(TOOL.get().addToolType(SwordTool.TOOL_TYPE, 0), ToolDefinitions.CLEAVER));
        flintAndBronze = ITEMS.register("flint_and_bronze", () -> new ModifiableItem(TOOL.get(), ToolDefinitions.FLINT_AND_BRONZE));
        travelersGear = ITEMS.registerEnum("travelers", ArmorSlotType.values(), type -> new ModifiableArmorItem(ArmorDefinitions.TRAVELERS, (ArmorSlotType)((Object)type), TOOL.get()));
        plateArmor = ITEMS.registerEnum("plate", ArmorSlotType.values(), type -> new ModifiableArmorItem(ArmorDefinitions.PLATE, (ArmorSlotType)((Object)type), TOOL.get()));
        slimesuit = new EnumObject.Builder(ArmorSlotType.class).putAll(ITEMS.registerEnum("slime", new ArmorSlotType[]{ArmorSlotType.BOOTS, ArmorSlotType.LEGGINGS}, type -> new ModifiableArmorItem(ArmorDefinitions.SLIMESUIT, (ArmorSlotType)((Object)type), TOOL.get()))).put((Enum)ArmorSlotType.CHESTPLATE, (Supplier)ITEMS.register("slime_chestplate", () -> new SlimelytraItem(ArmorDefinitions.SLIMESUIT, TOOL.get()))).put((Enum)ArmorSlotType.HELMET, (Supplier)ITEMS.register("slime_helmet", () -> new SlimeskullItem(ArmorDefinitions.SLIMESUIT, TOOL.get()))).build();
        hammerAttackParticle = PARTICLE_TYPES.register("hammer_attack", () -> new BasicParticleType(false));
        axeAttackParticle = PARTICLE_TYPES.register("axe_attack", () -> new BasicParticleType(false));
        indestructibleItem = ENTITIES.register("indestructible_item", () -> EntityType.Builder.func_220322_a(IndestructibleItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_220320_c());
        toolContainer = CONTAINERS.register("tool_container", ToolContainer::forClient);
    }
}

