/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.tileentity.chest;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.client.inventory.library.IScalingInventory;
import slimeknights.tconstruct.tables.tileentity.chest.ChestTileEntity;

public class TinkersChestTileEntity
extends ChestTileEntity {
    public static final String TAG_CHEST_COLOR = "color";
    public static final int DEFAULT_COLOR = 4224646;
    private int color = 4224646;
    private boolean hasColor = false;

    public TinkersChestTileEntity() {
        super((TileEntityType)TinkerTables.tinkersChestTile.get(), TConstruct.makeTranslationKey("gui", "tinkers_chest"), new TinkersChestItemHandler());
    }

    public void setColor(int color) {
        this.color = color;
        this.hasColor = true;
    }

    @Override
    public boolean canInsert(PlayerEntity player, ItemStack heldItem) {
        return false;
    }

    public void writeSynced(CompoundNBT tags) {
        super.writeSynced(tags);
        if (this.hasColor) {
            tags.func_74768_a(TAG_CHEST_COLOR, this.color);
        }
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT tags) {
        super.func_230337_a_(blockState, tags);
        if (tags.func_150297_b(TAG_CHEST_COLOR, 99)) {
            this.setColor(tags.func_74762_e(TAG_CHEST_COLOR));
        }
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.hasColor;
    }

    public static class TinkersChestItemHandler
    extends ItemStackHandler
    implements IScalingInventory {
        public TinkersChestItemHandler() {
            super(64);
        }

        public int getSlotLimit(int slot) {
            return 16;
        }

        @Override
        public int getVisualSize() {
            return this.getSlots();
        }
    }
}

