/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.tileentity.chest;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.tconstruct.tables.client.inventory.library.IScalingInventory;

public abstract class ScalingChestItemHandler
extends ItemStackHandler
implements IScalingInventory {
    protected static final int DEFAULT_MAX = 256;
    private int visualSize = 1;

    public ScalingChestItemHandler(int size) {
        super(size);
    }

    public ScalingChestItemHandler() {
        this(256);
    }

    public abstract boolean isItemValid(int var1, ItemStack var2);

    protected void onLoad() {
        int newLimit = this.getSlots();
        if (newLimit > 1 && this.getStackInSlot(newLimit - 1).func_190926_b()) {
            while (newLimit > 1 && this.getStackInSlot(newLimit - 2).func_190926_b()) {
                --newLimit;
            }
        }
        this.visualSize = newLimit;
    }

    private void updateVisualSize(int slotChanged, ItemStack stack) {
        int maxSlots = this.getSlots();
        if (slotChanged >= maxSlots) {
            return;
        }
        if (stack.func_190926_b()) {
            if (slotChanged + 1 == this.visualSize || slotChanged + 2 == this.visualSize && this.getStackInSlot(this.visualSize - 1).func_190926_b()) {
                while (this.visualSize > 1 && this.getStackInSlot(this.visualSize - 2).func_190926_b()) {
                    --this.visualSize;
                }
            }
        } else if (this.visualSize < maxSlots && this.visualSize < slotChanged + 2) {
            this.visualSize = slotChanged + 2;
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.updateVisualSize(slot, stack);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack result = super.insertItem(slot, stack, simulate);
        if (!simulate) {
            this.updateVisualSize(slot, this.getStackInSlot(slot));
        }
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = super.extractItem(slot, amount, simulate);
        if (!simulate) {
            this.updateVisualSize(slot, this.getStackInSlot(slot));
        }
        return result;
    }

    @Override
    public int getVisualSize() {
        return this.visualSize;
    }
}

