/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.component;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.component.SmelteryComponentTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.tank.ISmelteryTankHandler;

public abstract class SmelteryInputOutputTileEntity<T>
extends SmelteryComponentTileEntity {
    private final Capability<T> capability;
    protected final T emptyInstance;
    protected final NonNullConsumer<LazyOptional<T>> listener = new WeakConsumerWrapper((Object)this, (te, cap) -> te.clearHandler());
    @Nullable
    private LazyOptional<T> capabilityHolder = null;

    protected SmelteryInputOutputTileEntity(TileEntityType<?> type, Capability<T> capability, T emptyInstance) {
        super(type);
        this.capability = capability;
        this.emptyInstance = emptyInstance;
    }

    private void clearHandler() {
        if (this.capabilityHolder != null) {
            this.capabilityHolder.invalidate();
            this.capabilityHolder = null;
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.clearHandler();
    }

    @Override
    protected void setMaster(@Nullable BlockPos master, @Nullable Block block) {
        assert (this.field_145850_b != null);
        boolean masterChanged = false;
        if (!Objects.equals(this.getMasterPos(), master)) {
            this.clearHandler();
            masterChanged = true;
        }
        super.setMaster(master, block);
        if (masterChanged) {
            this.field_145850_b.func_230547_a_(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    protected LazyOptional<T> getCapability(TileEntity parent) {
        LazyOptional handler = parent.getCapability(this.capability);
        if (handler.isPresent()) {
            handler.addListener(this.listener);
            return LazyOptional.of(() -> handler.orElse(this.emptyInstance));
        }
        return LazyOptional.empty();
    }

    private LazyOptional<T> getCachedCapability() {
        if (this.capabilityHolder == null) {
            TileEntity te;
            BlockPos master;
            if (this.validateMaster() && (master = this.getMasterPos()) != null && this.field_145850_b != null && (te = this.field_145850_b.func_175625_s(master)) != null) {
                this.capabilityHolder = this.getCapability(te);
                return this.capabilityHolder;
            }
            this.capabilityHolder = LazyOptional.empty();
        }
        return this.capabilityHolder;
    }

    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction facing) {
        if (capability == this.capability) {
            return this.getCachedCapability().cast();
        }
        return super.getCapability(capability, facing);
    }

    public static class ChuteTileEntity
    extends SmelteryInputOutputTileEntity<IItemHandler> {
        public ChuteTileEntity() {
            this((TileEntityType)TinkerSmeltery.chute.get());
        }

        protected ChuteTileEntity(TileEntityType<?> type) {
            super(type, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EmptyItemHandler.INSTANCE);
        }
    }

    public static abstract class SmelteryFluidIO
    extends SmelteryInputOutputTileEntity<IFluidHandler> {
        protected SmelteryFluidIO(TileEntityType<?> type) {
            super(type, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EmptyFluidHandler.INSTANCE);
        }

        protected LazyOptional<IFluidHandler> makeWrapper(LazyOptional<IFluidHandler> capability) {
            return LazyOptional.of(() -> (IFluidHandler)capability.orElse(this.emptyInstance));
        }

        @Override
        protected LazyOptional<IFluidHandler> getCapability(TileEntity parent) {
            LazyOptional<IFluidHandler> capability;
            if (parent instanceof ISmelteryTankHandler && (capability = ((ISmelteryTankHandler)parent).getFluidCapability()).isPresent()) {
                capability.addListener(this.listener);
                return this.makeWrapper(capability);
            }
            return LazyOptional.empty();
        }
    }
}

