/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.TileEntityHelper;

public class FluidUpdatePacket
implements IThreadsafePacket {
    protected final BlockPos pos;
    protected final FluidStack fluid;

    public FluidUpdatePacket(BlockPos pos, FluidStack fluid) {
        this.pos = pos;
        this.fluid = fluid;
    }

    public FluidUpdatePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.fluid = buffer.readFluidStack();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeFluidStack(this.fluid);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(FluidUpdatePacket packet) {
            TileEntityHelper.getTile(IFluidPacketReceiver.class, (IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)packet.pos).ifPresent(te -> te.updateFluidTo(packet.fluid));
        }
    }

    public static interface IFluidPacketReceiver {
        public void updateFluidTo(FluidStack var1);
    }
}

