/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.FluidTooltipHandler;
import slimeknights.tconstruct.smeltery.item.TankItemFluidHandler;
import slimeknights.tconstruct.smeltery.tileentity.component.TankTileEntity;

public class TankItem
extends BlockTooltipItem {
    private static final String KEY_FLUID = TConstruct.makeTranslationKey("block", "tank.fluid");
    private static final String KEY_MB = TConstruct.makeTranslationKey("block", "tank.mb");
    private static final String KEY_INGOTS = TConstruct.makeTranslationKey("block", "tank.ingots");
    private static final String KEY_MIXED = TConstruct.makeTranslationKey("block", "tank.mixed");
    private final boolean limitStackSize;

    public TankItem(Block blockIn, Item.Properties builder, boolean limitStackSize) {
        super(blockIn, builder);
        this.limitStackSize = limitStackSize;
    }

    private static boolean isFilled(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_150297_b("tank", 10);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return TankItem.isFilled(stack) ? new ItemStack((IItemProvider)this) : ItemStack.field_190927_a;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.limitStackSize) {
            return super.getItemStackLimit(stack);
        }
        return TankItem.isFilled(stack) ? 16 : 64;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.getFluidAmount() > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent(KEY_FLUID, new Object[]{tank.getFluid().getDisplayName()}).func_240699_a_(TextFormatting.GRAY));
                int amount = tank.getFluidAmount();
                if (tank.getCapacity() % 144 != 0 || Screen.func_231173_s_()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(KEY_MB, new Object[]{amount}).func_240699_a_(TextFormatting.GRAY));
                } else {
                    int ingots = amount / 144;
                    int mb = amount % 144;
                    if (mb == 0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent(KEY_INGOTS, new Object[]{ingots}).func_240699_a_(TextFormatting.GRAY));
                    } else {
                        tooltip.add((ITextComponent)new TranslationTextComponent(KEY_MIXED, new Object[]{ingots, mb}).func_240699_a_(TextFormatting.GRAY));
                    }
                    tooltip.add(FluidTooltipHandler.HOLD_SHIFT);
                }
            }
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TankItemFluidHandler(stack);
    }

    public static ItemStack setTank(ItemStack stack, FluidTank tank) {
        if (tank.isEmpty()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null) {
                nbt.func_82580_o("tank");
                if (nbt.isEmpty()) {
                    stack.func_77982_d(null);
                }
            }
        } else {
            stack.func_196082_o().func_218657_a("tank", (INBT)tank.writeToNBT(new CompoundNBT()));
        }
        return stack;
    }

    public static FluidTank getFluidTank(ItemStack stack) {
        FluidTank tank = new FluidTank(TankTileEntity.getCapacity(stack.func_77973_b()));
        if (stack.func_77942_o()) {
            assert (stack.func_77978_p() != null);
            tank.readFromNBT(stack.func_77978_p().func_74775_l("tank"));
        }
        return tank;
    }
}

