/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.util.ResourceManagerSpriteReader;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.shared.network.GeneratePartTexturesPacket;

public class ClientGeneratePartTexturesCommand {
    private static final Logger log = LogManager.getLogger(ClientGeneratePartTexturesCommand.class);
    private static final String SUCCESS_KEY = TConstruct.makeTranslationKey("command", "generate_part_textures.finish");
    private static final ITextComponent NO_PARTS = TConstruct.makeTranslation("command", "generate_part_textures.no_parts");
    private static final ITextComponent NO_MATERIALS = TConstruct.makeTranslation("command", "generate_part_textures.no_materials");
    private static final String PACK_NAME = "TinkersConstructGeneratedPartTextures";
    private static final String GENERATOR_PART_TEXTURES = "models/tconstruct_generator_part_textures.json";

    protected static ITextComponent getOutputComponent(File file) {
        return new StringTextComponent(file.getAbsolutePath()).func_240700_a_(style -> style.setUnderlined(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
    }

    public static void generateTextures(GeneratePartTexturesPacket.Operation operation, String modId, String materialPath) {
        long time = System.nanoTime();
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        MaterialPartTextureGenerator.runCallbacks(null, manager);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        List<AbstractPartSpriteProvider.PartSpriteInfo> partSprites = ClientGeneratePartTexturesCommand.loadPartSprites(manager);
        if (partSprites.isEmpty()) {
            if (player != null) {
                player.func_146105_b(NO_PARTS, false);
            }
            return;
        }
        Predicate<ResourceLocation> validMaterialId = loc -> !(!modId.isEmpty() && !modId.equals(loc.func_110624_b()) || !materialPath.isEmpty() && !materialPath.equals(loc.func_110623_a()));
        List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materialSprites = ClientGeneratePartTexturesCommand.loadMaterialRenderInfoGenerators(manager, validMaterialId);
        if (materialSprites.isEmpty()) {
            if (player != null) {
                player.func_146105_b(NO_MATERIALS, false);
            }
            return;
        }
        Path path = Minecraft.func_71410_x().func_195549_J().toPath().resolve(PACK_NAME);
        BiConsumer<ResourceLocation, NativeImage> saver = (outputPath, image) -> ClientGeneratePartTexturesCommand.saveImage(path, outputPath, image);
        ClientGeneratePartTexturesCommand.savePackMcmeta(path);
        ResourceManagerSpriteReader spriteReader = new ResourceManagerSpriteReader(manager, "textures/item/tool");
        MutableInt generated = new MutableInt(0);
        Predicate<ResourceLocation> shouldGenerate = operation == GeneratePartTexturesPacket.Operation.ALL ? exists -> {
            generated.add(1);
            return true;
        } : loc -> {
            if (!spriteReader.exists((ResourceLocation)loc)) {
                generated.add(1);
                return true;
            }
            return false;
        };
        for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materialSprites) {
            for (AbstractPartSpriteProvider.PartSpriteInfo part : partSprites) {
                if (!material.supportStatType(part.getStatType())) continue;
                MaterialPartTextureGenerator.generateSprite(spriteReader, material, part, shouldGenerate, saver);
            }
        }
        spriteReader.closeAll();
        long deltaTime = System.nanoTime() - time;
        int count = generated.getValue();
        MaterialPartTextureGenerator.runCallbacks(null, null);
        log.info("Finished generating {} textures in {} ms", (Object)count, (Object)Float.valueOf((float)deltaTime / 1000000.0f));
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent(SUCCESS_KEY, new Object[]{count, Float.valueOf((float)(deltaTime / 1000000L) / 1000.0f), ClientGeneratePartTexturesCommand.getOutputComponent(path.toFile())}), false);
        }
    }

    private static void savePackMcmeta(Path folder) {
        Path path = folder.resolve("pack.mcmeta");
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "Generated Resources from the Tinkers' Construct Part Texture Generator");
        pack.addProperty("pack_format", (Number)6);
        meta.add("pack", (JsonElement)pack);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = MaterialRenderInfoLoader.GSON.toJson((JsonElement)meta);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(json);
            }
        }
        catch (IOException e) {
            log.error("Couldn't create pack.mcmeta for part textures", (Throwable)e);
        }
    }

    private static void saveImage(Path folder, ResourceLocation location, NativeImage image) {
        Path path = folder.resolve(Paths.get(ResourcePackType.CLIENT_RESOURCES.func_198956_a(), location.func_110624_b(), "textures/item/tool", location.func_110623_a() + ".png"));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            image.func_209270_a(path);
        }
        catch (IOException e) {
            log.error("Couldn't create image for {}", (Object)location, (Object)e);
        }
    }

    private static List<AbstractPartSpriteProvider.PartSpriteInfo> loadPartSprites(IResourceManager manager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        block15: for (String namespace : manager.func_199001_a()) {
            ResourceLocation location = new ResourceLocation(namespace, GENERATOR_PART_TEXTURES);
            if (!manager.func_219533_b(location)) continue;
            try {
                List resources = manager.func_199004_b(location);
                for (int r = resources.size() - 1; r >= 0; --r) {
                    IResource resource = (IResource)resources.get(r);
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
                        Throwable throwable = null;
                        try {
                            JsonObject object = JSONUtils.func_212743_a((Reader)reader);
                            List parts = JsonHelper.parseList((JsonObject)object, (String)"parts", (element, name) -> {
                                JsonObject part = JSONUtils.func_151210_l((JsonElement)element, (String)name);
                                ResourceLocation path = JsonHelper.getResourceLocation((JsonObject)part, (String)"path");
                                MaterialStatsId statId = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)part, (String)"statType"));
                                return new AbstractPartSpriteProvider.PartSpriteInfo(path, statId);
                            });
                            builder.addAll((Iterable)parts);
                            if (!JSONUtils.func_151209_a((JsonObject)object, (String)"replace", (boolean)false)) continue;
                            continue block15;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue block15;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue block15;
                            }
                            reader.close();
                            continue block15;
                        }
                    }
                    catch (IOException ex) {
                        log.error("Failed to load modifier models from {} for pack {}", (Object)location, (Object)resource.func_199026_d(), (Object)ex);
                    }
                }
            }
            catch (IOException ex) {
                log.error("Failed to load modifier models from {}", (Object)location, (Object)ex);
            }
        }
        return builder.build();
    }

    private static List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> loadMaterialRenderInfoGenerators(IResourceManager manager, Predicate<ResourceLocation> validMaterialId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int trim = "models/tool_materials".length() + 1;
        for (ResourceLocation location : manager.func_199003_a("models/tool_materials", loc -> loc.endsWith(".json"))) {
            String path = location.func_110623_a();
            MaterialId id = new MaterialId(location.func_110624_b(), path.substring(trim, path.length() - 5));
            if (!validMaterialId.test(id)) continue;
            try {
                IResource iresource = manager.func_199002_a(location);
                Throwable throwable = null;
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            MaterialRenderInfoJson json = (MaterialRenderInfoJson)MaterialRenderInfoLoader.GSON.fromJson((Reader)reader, MaterialRenderInfoJson.class);
                            MaterialRenderInfoJson.MaterialGeneratorJson generator = json.getGenerator();
                            if (generator == null) continue;
                            builder.add((Object)new AbstractMaterialSpriteProvider.MaterialSpriteInfo((ResourceLocation)LogicHelper.defaultIfNull((Object)json.getTexture(), (Object)((Object)id)), (String[])LogicHelper.defaultIfNull((Object)json.getFallbacks(), (Object)new String[0]), generator));
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to read tool part texture generator info for {}", (Object)id, (Object)e);
            }
            catch (Exception exception) {}
        }
        return builder.build();
    }
}

