/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.IdentityHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import slimeknights.tconstruct.common.Sounds;

public class SlimeBounceHandler {
    private static final IdentityHashMap<Entity, BounceInfo> BOUNCING_ENTITIES = new IdentityHashMap();

    private SlimeBounceHandler() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(SlimeBounceHandler::onLivingTick);
        MinecraftForge.EVENT_BUS.addListener(SlimeBounceHandler::serverStopping);
    }

    public static void addBounceHandler(LivingEntity entity) {
        SlimeBounceHandler.addBounceHandler(entity, 0.0);
    }

    public static void addBounceHandler(LivingEntity entity, double bounce) {
        if (entity instanceof FakePlayer) {
            return;
        }
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info == null) {
            BOUNCING_ENTITIES.put((Entity)entity, new BounceInfo(entity, bounce));
        } else if (bounce != 0.0) {
            info.bounce = bounce;
            info.bounceTick = entity.field_70173_aa + 1;
            Vector3d motion = entity.func_213322_ci();
            info.lastMagSq = motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c;
            info.lastAngle = MathHelper.func_181159_b((double)motion.field_72449_c, (double)motion.field_72450_a);
        }
    }

    private static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info != null) {
            boolean isInAir;
            if (entity.func_184613_cA()) {
                BOUNCING_ENTITIES.remove(entity);
                return;
            }
            if (entity.field_70173_aa == info.bounceTick) {
                Vector3d motion = entity.func_213322_ci();
                entity.func_213293_j(motion.field_72450_a, info.bounce, motion.field_72449_c);
                info.bounceTick = 0;
            }
            boolean bl = isInAir = !entity.func_233570_aj_() && !entity.func_70090_H() && !entity.func_70617_f_();
            if (isInAir && info.lastMagSq > 0.0) {
                Vector3d motion = entity.func_213322_ci();
                double motionSq = motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c;
                if (motionSq == 0.0) {
                    if (info.stopMagTick == 0) {
                        info.stopMagTick = entity.field_70173_aa + 5;
                    } else if (entity.field_70173_aa > info.stopMagTick) {
                        info.lastMagSq = 0.0;
                    }
                } else if (motionSq < info.lastMagSq) {
                    info.stopMagTick = 0;
                    double boost = Math.sqrt(info.lastMagSq / motionSq) * (double)0.95f;
                    if (boost > 1.0) {
                        entity.func_213293_j(motion.field_72450_a * boost, motion.field_72448_b, motion.field_72449_c * boost);
                        entity.field_70160_al = true;
                        info.lastMagSq = info.lastMagSq * (double)0.95f * (double)0.95f;
                        double newAngle = MathHelper.func_181159_b((double)motion.field_72449_c, (double)motion.field_72450_a);
                        if (Math.abs(newAngle - info.lastAngle) > 1.0) {
                            entity.func_184185_a(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
                        }
                        info.lastAngle = newAngle;
                    } else {
                        info.lastMagSq = motionSq;
                        info.lastAngle = MathHelper.func_181159_b((double)motion.field_72449_c, (double)motion.field_72450_a);
                    }
                }
            }
            if (info.wasInAir && !isInAir) {
                if (info.endHandler == 0) {
                    info.endHandler = entity.field_70173_aa + 5;
                } else if (entity.field_70173_aa > info.endHandler) {
                    BOUNCING_ENTITIES.remove(entity);
                }
            } else {
                info.endHandler = 0;
                info.wasInAir = true;
            }
        }
    }

    private static void serverStopping(FMLServerStoppingEvent event) {
        BOUNCING_ENTITIES.clear();
    }

    private static class BounceInfo {
        private double bounce;
        private int bounceTick;
        private int stopMagTick;
        private double lastMagSq;
        private boolean wasInAir = false;
        private int endHandler = 0;
        private double lastAngle;

        public BounceInfo(LivingEntity entity, double bounce) {
            this.bounce = bounce;
            this.bounceTick = bounce != 0.0 ? entity.field_70173_aa + 1 : 0;
            Vector3d motion = entity.func_213322_ci();
            this.lastMagSq = motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c;
        }
    }
}

