/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IElytraFlightModifier;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class ModifiableArmorItem
extends ArmorItem
implements IModifiableDisplay {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final ResourceLocation PIGLIN_NEUTRAL = TConstruct.getResource("piglin_neutral");
    public static final ResourceLocation ELYTRA = TConstruct.getResource("elyta");
    private final ToolDefinition toolDefinition;
    private ItemStack toolForRendering = null;

    public ModifiableArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builderIn, ToolDefinition toolDefinition) {
        super(materialIn, slot, builderIn);
        this.toolDefinition = toolDefinition;
    }

    public ModifiableArmorItem(ModifiableArmorMaterial material, ArmorSlotType slotType, Item.Properties properties) {
        this(material, slotType.getEquipmentSlot(), properties, Objects.requireNonNull(material.getArmorDefinition(slotType), "Missing tool definition for " + (Object)((Object)slotType)));
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.func_190936_d() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return ModifierUtil.checkVolatileFlag(stack, PIGLIN_NEUTRAL);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        ToolStack.verifyTag((Item)this, nbt, this.getToolDefinition());
        return true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        ToolStack.ensureInitialized(stack, this.getToolDefinition());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        ActionResultType result = ToolInventoryCapability.tryOpenContainer(stack, null, this.getToolDefinition(), playerIn, Util.getSlotType(handIn));
        if (result.func_226246_a_()) {
            return new ActionResult(result, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ModifierUtil.checkVolatileFlag(stack, SHINY);
    }

    public Rarity func_77613_e(ItemStack stack) {
        int rarity = ModifierUtil.getVolatileInt(stack, RARITY);
        return Rarity.values()[MathHelper.func_76125_a((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return ModifierUtil.checkVolatileFlag(stack, INDESTRUCTIBLE_ENTITY);
    }

    public Entity createEntity(World world, Entity original, ItemStack stack) {
        if (ModifierUtil.checkVolatileFlag(stack, INDESTRUCTIBLE_ENTITY)) {
            IndestructibleItemEntity entity = new IndestructibleItemEntity(world, original.func_226277_ct_(), original.func_226278_cu_(), original.func_226281_cx_(), stack);
            entity.setPickupDelayFrom(original);
            return entity;
        }
        return null;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        if (!this.func_77645_m()) {
            return 0;
        }
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        return tool.isBroken() ? durability + 1 : durability;
    }

    public int getDamage(ItemStack stack) {
        if (!this.func_77645_m()) {
            return 0;
        }
        return ToolStack.from(stack).getDamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (this.func_77645_m()) {
            ToolStack.from(stack).setDamage(damage);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        if (this.func_77645_m() && ToolDamageUtil.damage(ToolStack.from(stack), amount, damager, stack)) {
            onBroken.accept(damager);
        }
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ToolDamageUtil.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ToolDamageUtil.getDamageForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ToolDamageUtil.getRGBDurabilityForDisplay(stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IModifierToolStack tool, EquipmentSlotType slot) {
        if (slot != this.func_185083_B_()) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!tool.isBroken()) {
            StatsNBT statsNBT = tool.getStats();
            UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
            builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "tconstruct.armor.armor", (double)statsNBT.getFloat(ToolStats.ARMOR), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uuid, "tconstruct.armor.toughness", (double)statsNBT.getFloat(ToolStats.ARMOR_TOUGHNESS), AttributeModifier.Operation.ADDITION));
            double knockbackResistance = statsNBT.getFloat(ToolStats.KNOCKBACK_RESISTANCE);
            if (knockbackResistance != 0.0) {
                builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "tconstruct.armor.knockback_resistance", knockbackResistance, AttributeModifier.Operation.ADDITION));
            }
            BiConsumer<Attribute, AttributeModifier> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().addAttributes(tool, entry.getLevel(), slot, attributeConsumer);
            }
        }
        return builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (slot != this.func_185083_B_() || nbt == null) {
            return ImmutableMultimap.of();
        }
        return this.getAttributeModifiers(ToolStack.from(stack), slot);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.field_77881_a == EquipmentSlotType.CHEST && !ToolDamageUtil.isBroken(stack) && ModifierUtil.checkVolatileFlag(stack, ELYTRA);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        ToolStack tool;
        if (this.field_77881_a == EquipmentSlotType.CHEST && !(tool = ToolStack.from(stack)).isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                IElytraFlightModifier elytraFlight = entry.getModifier().getModule(IElytraFlightModifier.class);
                if (elytraFlight == null || elytraFlight.elytraFlightTick(tool, entry.getLevel(), entity, flightTicks)) continue;
                return false;
            }
            if (!entity.field_70170_p.field_72995_K && (flightTicks + 1) % 20 == 0) {
                ToolDamageUtil.damageAnimated((IModifierToolStack)tool, 1, entity, EquipmentSlotType.CHEST);
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof LivingEntity) {
            List<ModifierEntry> modifiers;
            ToolStack tool = ToolStack.from(stack);
            if (!worldIn.field_72995_K) {
                tool.ensureHasData();
            }
            if (!(modifiers = tool.getModifierList()).isEmpty()) {
                LivingEntity living = (LivingEntity)entityIn;
                boolean isCorrectSlot = living.func_184582_a(this.field_77881_a) == stack;
                for (ModifierEntry entry : modifiers) {
                    entry.getModifier().onInventoryTick(tool, entry.getLevel(), worldIn, living, itemSlot, isSelected, isCorrectSlot, stack);
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return TooltipUtil.getDisplayName(stack, this.getToolDefinition());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TooltipUtil.addInformation((IModifiableDisplay)this, stack, worldIn, tooltip, TooltipKey.fromScreen(), flagIn);
    }

    @Override
    public List<ITextComponent> getStatInformation(IModifierToolStack tool, @Nullable PlayerEntity player, List<ITextComponent> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        tooltips = TooltipUtil.getArmorStats(tool, player, tooltips, key, tooltipFlag);
        TooltipUtil.addAttributes(this, tool, player, tooltips, TooltipUtil.SHOW_ARMOR_ATTRIBUTES, this.func_185083_B_());
        return tooltips;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ToolBuildHandler.addDefaultSubItems(this, items, new IMaterial[0]);
        }
    }

    @Override
    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((Item)this, this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    @Override
    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }
}

