/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;

public class ModifierLootingHandler {
    private static final Map<UUID, EquipmentSlotType> LOOTING_OFFHAND = new HashMap<UUID, EquipmentSlotType>();
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLooting);
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLeaveServer);
    }

    @Deprecated
    public static void setLootingHand(LivingEntity entity, Hand hand) {
        ModifierLootingHandler.setLootingSlot(entity, Util.getSlotType(hand));
    }

    public static void setLootingSlot(LivingEntity entity, EquipmentSlotType slotType) {
        if (slotType == EquipmentSlotType.MAINHAND) {
            LOOTING_OFFHAND.remove(entity.func_110124_au());
        } else {
            LOOTING_OFFHAND.put(entity.func_110124_au(), slotType);
        }
    }

    @Deprecated
    public static Hand getLootingHand(@Nullable LivingEntity entity) {
        return entity != null && LOOTING_OFFHAND.get(entity.func_110124_au()) == EquipmentSlotType.OFFHAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
    }

    public static EquipmentSlotType getLootingSlot(@Nullable LivingEntity entity) {
        return entity != null ? LOOTING_OFFHAND.getOrDefault(entity.func_110124_au(), EquipmentSlotType.MAINHAND) : EquipmentSlotType.MAINHAND;
    }

    private static void onLooting(LootingLevelEvent event) {
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity source = damageSource.func_76346_g();
        if (source instanceof LivingEntity) {
            LivingEntity holder = (LivingEntity)source;
            EquipmentSlotType slotType = ModifierLootingHandler.getLootingSlot(holder);
            ItemStack held = holder.func_184582_a(slotType);
            int level = event.getLootingLevel();
            if (TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)held.func_77973_b())) {
                ToolStack tool = ToolStack.from(held);
                level = ModifierUtil.getLootingLevel(tool, holder, (Entity)event.getEntityLiving(), damageSource);
            } else if (slotType != EquipmentSlotType.MAINHAND) {
                level = 0;
            }
            level = ModifierUtil.getLeggingsLootingLevel(holder, (Entity)event.getEntityLiving(), damageSource, level);
            event.setLootingLevel(level);
        }
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        LOOTING_OFFHAND.remove(event.getPlayer().func_110124_au());
    }
}

