/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class EquipmentChangeContext
extends EquipmentContext {
    private final EquipmentSlotType changedSlot;
    private final ItemStack original;
    private final ItemStack replacement;
    @Nullable
    private final IModifierToolStack originalTool;

    public EquipmentChangeContext(LivingEntity entity, EquipmentSlotType changedSlot, ItemStack original, ItemStack replacement) {
        super(entity);
        this.changedSlot = changedSlot;
        this.original = original;
        this.replacement = replacement;
        this.originalTool = EquipmentChangeContext.getToolStackIfModifiable(original);
        int replacementIndex = changedSlot.func_188452_c();
        this.toolsInSlots[replacementIndex] = EquipmentChangeContext.getToolStackIfModifiable(replacement);
        this.fetchedTool[replacementIndex] = true;
    }

    @Nullable
    public IModifierToolStack getReplacementTool() {
        return this.getToolInSlot(this.changedSlot);
    }

    public EquipmentSlotType getChangedSlot() {
        return this.changedSlot;
    }

    public ItemStack getOriginal() {
        return this.original;
    }

    public ItemStack getReplacement() {
        return this.replacement;
    }

    @Nullable
    public IModifierToolStack getOriginalTool() {
        return this.originalTool;
    }
}

