/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeSerializer;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderInventory;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;

public class ItemPartRecipe
implements IDisplayPartBuilderRecipe {
    private final ResourceLocation id;
    private final MaterialId materialId;
    @Nullable
    private IMaterial material = null;
    private final Pattern pattern;
    private final int cost;
    private final ItemOutput result;

    @Override
    public IMaterial getMaterial() {
        if (this.material == null) {
            this.material = MaterialRegistry.getMaterial(this.materialId);
        }
        return this.material;
    }

    @Override
    public boolean partialMatch(IPartBuilderInventory inv) {
        if (inv.getPatternStack().func_77973_b() != TinkerTables.pattern.get()) {
            return false;
        }
        if (!inv.getStack().func_190926_b()) {
            MaterialRecipe materialRecipe = inv.getMaterial();
            return materialRecipe != null && materialRecipe.getMaterial() == this.getMaterial();
        }
        return true;
    }

    public boolean matches(IPartBuilderInventory inv, World worldIn) {
        MaterialRecipe materialRecipe = inv.getMaterial();
        return materialRecipe != null && materialRecipe.getMaterial() == this.getMaterial() && inv.getStack().func_190916_E() >= materialRecipe.getItemsUsed(this.cost);
    }

    public ItemStack func_77571_b() {
        return this.result.get();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.itemPartBuilderSerializer.get();
    }

    public ItemPartRecipe(ResourceLocation id, MaterialId materialId, Pattern pattern, int cost, ItemOutput result) {
        this.id = id;
        this.materialId = materialId;
        this.pattern = pattern;
        this.cost = cost;
        this.result = result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public MaterialId getMaterialId() {
        return this.materialId;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ItemPartRecipe> {
        public ItemPartRecipe read(ResourceLocation id, JsonObject json) {
            MaterialId materialId = MaterialRecipeSerializer.getMaterial(json, "material");
            Pattern pattern = new Pattern(JSONUtils.func_151200_h((JsonObject)json, (String)"pattern"));
            int cost = JSONUtils.func_151203_m((JsonObject)json, (String)"cost");
            ItemOutput result = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"result"));
            return new ItemPartRecipe(id, materialId, pattern, cost, result);
        }

        @Override
        @Nullable
        protected ItemPartRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            MaterialId materialId = new MaterialId(buffer.func_150789_c(Short.MAX_VALUE));
            Pattern pattern = new Pattern(buffer.func_150789_c(Short.MAX_VALUE));
            int cost = buffer.func_150792_a();
            ItemOutput result = ItemOutput.read((PacketBuffer)buffer);
            return new ItemPartRecipe(id, materialId, pattern, cost, result);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, ItemPartRecipe recipe) {
            buffer.func_180714_a(recipe.materialId.toString());
            buffer.func_180714_a(recipe.pattern.toString());
            buffer.func_150787_b(recipe.cost);
            recipe.result.write(buffer);
        }
    }
}

